package com.xdja.im.uikit.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;

import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：vicent
 * 时间：2019/2/26
 */
public abstract class BaseRecyclerListDialog extends Dialog {


    private RecyclerView mList;

    private BaseRecyclerListAdapter mAdapter;

    private List<ImOption> mOptions = new ArrayList<>();

    private int mItemPosition;

    private Context mContext;

    private onItemClickListener onItemClickListener;

    public void setOnItemClickListener(onItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public BaseRecyclerListDialog(@NonNull Context context) {
        super(context, R.style.im_uikit_BaseDialogStyle);
        this.mContext = context;
        setContentView(R.layout.im_uikit_dialg_option_recycler_list);
        setCancelable(true);
        initView();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            WindowManager.LayoutParams lp = getWindow().getAttributes();
            int screenWidth = getWindow().getWindowManager().getDefaultDisplay().getWidth(); // 屏幕宽
            lp.width = (int) (screenWidth * 0.8); // 宽度
            getWindow().setAttributes(lp);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView() {

        mList = (RecyclerView) findViewById(R.id.lv_options);
        mAdapter = new BaseRecyclerListAdapter(mOptions);
        mList.addItemDecoration(new DividerItemDecoration(mContext, DividerItemDecoration.VERTICAL));
        mList.setAdapter(mAdapter);
        mAdapter.addOnItemClickListener(new onItemClickListener() {
            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                if (onItemClickListener != null) {
                    onItemClickListener.onItemClick(view, option, mItemPosition);
                }
            }
        });
        addData(getOptions());
    }


    /**
     * 添加Item数据
     *
     * @param options
     */
    public void addData(List<ImOption> options) {
        if (options == null || options.size() == 0) {
            return;
        }
        mOptions.clear();
        mOptions.addAll(options);
        mAdapter.notifyDataSetChanged();
    }

    /**
     * 显示Dialog
     *
     * @param position
     */
    public void show(int position) {
        super.show();
        mItemPosition = position;
    }


    class BaseRecyclerListAdapter extends RecyclerView.Adapter<BaseRecyclerListHolder> {

        private List<ImOption> mOptions;

        private onItemClickListener itemClickListener;

        public BaseRecyclerListAdapter(List<ImOption> mOptions) {
            this.mOptions = mOptions;
        }

        public void addOnItemClickListener(onItemClickListener onItemClickListener) {
            itemClickListener = onItemClickListener;
        }


        @Override
        public BaseRecyclerListHolder onCreateViewHolder(ViewGroup parent, int viewType) {

            return new BaseRecyclerListHolder(LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.im_uikit_item_dialog_option, parent, false));
        }

        @Override
        public void onBindViewHolder(final BaseRecyclerListHolder holder, final int position) {

            final ImOption imOption = getItem(position);
            if (imOption != null) {
                holder.mOptionTv.setText(imOption.getValue());
                holder.itemView.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (itemClickListener != null) {
                            itemClickListener.onItemClick(holder.itemView, imOption, position);
                        }
                    }
                });
            }
        }

        @Override
        public int getItemCount() {
            return mOptions.size();
        }

        private ImOption getItem(int position) {
            return mOptions.get(position);
        }
    }


    class BaseRecyclerListHolder extends RecyclerView.ViewHolder {

        TextView mOptionTv;

        public BaseRecyclerListHolder(View itemView) {
            super(itemView);
            this.mOptionTv = (TextView) itemView.findViewById(R.id.tv_option);
        }
    }


    public abstract List<ImOption> getOptions();


    public interface onItemClickListener {
        /**
         * item点击事件回调
         *
         * @param view         当前点击view
         * @param option       选项属性
         * @param itemPosition dialog关联item位置
         */
        void onItemClick(View view, ImOption option, int itemPosition);
    }
}
