package com.xdja.im.uikit.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.xdja.im.uikit.R;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-09-11 11:23
 * @Version V1.0
 * @Description:自定义Dialiog类型
 */
public class CustomDialog extends Dialog implements View.OnClickListener {

    /**
     * 上下文
     */
    private Context mContext;
    /**
     * Dialog内容
     */
    private TextView mContentTv;
    /**
     * Dialog标题
     */
    private TextView mTitleTv;
    /**
     * 确定
     */
    private TextView mSubmitTv;
    /**
     * 取消
     */
    private TextView mCancelTv;

    /**
     * 标题
     */
    private String mTitle;
    /**
     * Content
     */
    private String mContent;
    /**
     * 确定按钮文本
     */
    private String mPositiveName;
    /**
     * 取消按钮文本
     */
    private String mNegativeName;
    /**
     * 取消按钮文本是否显示
     */
    private boolean ifShowNegative = true;
    /**
     * title resId
     */
    private int mTitleResId;
    /**
     * content resId;
     */
    private int mContentResId;
    /**
     * 确定按钮resId
     */
    private int mPositiveResId;
    /**
     * 取消按钮resId
     */
    private int mNagativeResId;

    /**
     * 回调
     */
    private OnCloseListener mListener;

    public CustomDialog(Context context) {
        super(context);
        this.mContext = context;
    }

    public CustomDialog(Context context, String content) {
        super(context, R.style.im_uikit_dialog);
        this.mContext = context;
        this.mContent = content;
    }

    public CustomDialog(Context context, int themeResId, String content) {
        super(context, themeResId);
        this.mContext = context;
        this.mContent = content;
    }

    public CustomDialog(Context context, OnCloseListener listener) {
        super(context, R.style.im_uikit_dialog);
        this.mContext = context;
        this.mListener = listener;
    }

    public CustomDialog(Context context, int themeResId, OnCloseListener listener) {
        super(context, themeResId);
        this.mContext = context;
        this.mListener = listener;
    }

    public CustomDialog setDialogTitle(String mTitle) {
        this.mTitle = mTitle;
        return this;
    }

    public CustomDialog setDialogTitle(@StringRes int resId) {
        this.mTitleResId = resId;
        return this;
    }

    public CustomDialog setDialogContent(String content) {
        this.mContent = content;
        return this;
    }

    public CustomDialog setDialogContent(@StringRes int resId) {
        this.mContentResId = resId;
        return this;
    }

    public CustomDialog setPositiveButton(String name) {
        this.mPositiveName = name;
        return this;
    }

    public CustomDialog setPositiveButton(@StringRes int resId) {
        this.mPositiveResId = resId;
        return this;
    }

    public CustomDialog setNegativeButton(String name) {
        this.mNegativeName = name;
        return this;
    }

    public CustomDialog setNegativeButton(@StringRes int resId) {
        this.mNagativeResId  = resId;
        return this;
    }

    public CustomDialog setIfShowNegative(boolean ifShowNegative) {
        this.ifShowNegative = ifShowNegative;
        return this;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.im_uikit_dialog_costom);

        setCanceledOnTouchOutside(false);
//        setOnCancelListener(new OnCancelListener() {
//            @Override
//            public void onCancel(DialogInterface dialog) {
//                dismiss();
//                if (mListener != null) {
//                    mListener.onClick(CustomDialog.this, false);
//                }
//            }
//        });

        initView();
    }

    private void initView() {
        mContentTv = (TextView) findViewById(R.id.tv_content);
        mTitleTv = (TextView) findViewById(R.id.tv_title);
        mSubmitTv = (TextView) findViewById(R.id.tv_submit);
        mCancelTv = (TextView) findViewById(R.id.tv_cancel);
        mSubmitTv.setOnClickListener(this);
        mCancelTv.setOnClickListener(this);

        if (!TextUtils.isEmpty(mTitle)) {
            mTitleTv.setText(mTitle);
        }

        if (mTitleResId > 0) {
            mTitleTv.setText(mTitleResId);
        }

        if (!TextUtils.isEmpty(mContent)) {
            mContentTv.setText(mContent);
        }

        if (mContentResId > 0) {
            mContentTv.setText(mContentResId);
        }

        if (!TextUtils.isEmpty(mPositiveName)) {
            mSubmitTv.setText(mPositiveName);
        }

        if (mPositiveResId > 0) {
            mSubmitTv.setText(mPositiveResId);
        }

        if (!TextUtils.isEmpty(mNegativeName)) {
            mCancelTv.setText(mNegativeName);
        }

        if (!ifShowNegative){
            mCancelTv.setVisibility(View.GONE);
        }

        if (mNagativeResId > 0) {
            mCancelTv.setText(mNagativeResId);
        }
    }

    public CustomDialog setCancel(boolean flag) {
        setCancelable(flag);
        return this;
    }

    @Override
    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_cancel) {
            if (mListener != null) {
                mListener.onClick(this, false);
            }
            this.dismiss();

        } else if (i == R.id.tv_submit) {
            if (mListener != null) {
                mListener.onClick(this, true);
            }
            this.dismiss();
        }
    }

    public interface OnCloseListener {
        /**
         * 点击事件回调
         *
         * @param dialog
         * @param confirm
         */
        void onClick(Dialog dialog, boolean confirm);
    }
}
