package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:43
 * @Version V1.0
 * @Description:
 */
public class ViewSendFileItem extends BaseSendItem {

    /**
     * 文件类型logo
     */
    private ImageView mLogoImg;
    /**
     * 文件名称
     */
    private TextView mFileNameTv;
    /**
     * 文件大小
     */
    private TextView mFileSizeTv;
    /**
     * 文件下载进度条
     */
    private ProgressBar mLoadingPBar;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_file;
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        mLogoImg.setImageBitmap(null);
        mFileNameTv.setText("");
        mFileSizeTv.setText("");
        mLoadingPBar.setProgress(0);
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        mLogoImg = (ImageView) view.findViewById(R.id.img_file_flag);
        mFileNameTv = (TextView) view.findViewById(R.id.tv_file_name);
        mFileSizeTv = (TextView) view.findViewById(R.id.tv_file_size);
        mLoadingPBar = (ProgressBar) view.findViewById(R.id.pbar_file_progress);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
//                getPresenter().openNormalFile(dataSource);
                NormalFileInfo fileInfo = (NormalFileInfo) dataSource.getFileInfo();
                if (fileInfo == null) {
                    LogUtil.e("ERROR: start open file, but file info is null.");
                    return;
                }
                //文件完整性判断
                if (FileUtils.getFileExistAndComplete(fileInfo.getFilePath(),fileInfo.getFileState())) {
                    getPresenter().openNormalFile(dataSource);
                } else {
                    getPresenter().loadNormalFile(dataSource);
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        NormalFileInfo normalFileInfo = (NormalFileInfo) dataSource.getFileInfo();
        if (normalFileInfo == null) {
            LogUtil.e("ERROR: Send file info is null.");
            return;
        }

        mFileNameTv.setText(normalFileInfo.getFileName());
        mFileSizeTv.setText(FileSizeUtils.formatFileSize(normalFileInfo.getFileSize()));
        mLogoImg.setImageResource(FileUtils.getIconWithSuffix(normalFileInfo.getFilePath()));
        //要上传的文件已经存在并且未上传完成的情况下，显示进度条
        if (dataSource.getMessageState() == ConstDef.STATE_SENDING) {
            mLoadingPBar.setVisibility(View.VISIBLE);
            mLoadingPBar.setProgress((int) (getTranslateSize(normalFileInfo) * 100.0f / normalFileInfo.getFileSize()));
        } else {
            mLoadingPBar.setVisibility(View.GONE);
        }
    }

    /**
     * 获取文件传输大小
     *
     * @param fileInfo
     * @return
     */
    private long getTranslateSize(NormalFileInfo fileInfo) {
        return Math.max(TranslateInfoUtil.getTranslateSize(fileInfo.getTalkMessageId()),
                fileInfo.getTranslateSize());
    }

}
