package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.GifImageView;

import static com.xdja.im.lib.filemanage.util.HistoryFileUtils.isFileExist;


/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:42
 * @Version V1.0
 * @Description:
 */
public class ViewSendImageItem extends BaseSendItem {

    private static final int MAX_PLAY_GIF = 3 * 1024 * 1024;

    /**
     * 图片加载显示控件
     */
    private ChatImageView mChatImage;
    /**
     * gif
     */
    private GifImageView mGifImageView;
    /**
     * 闪信标识
     */
    private ImageView mBombFlagImg;

    /**
     * 图片接收进度
     */
    private ProgressBar progressBar;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mChatImage = (ChatImageView) findViewById(R.id.img_send_image);
        mGifImageView = (GifImageView) findViewById(R.id.img_send_gif_image);
        mBombFlagImg = (ImageView) findViewById(R.id.img_bomb_flag);
        progressBar = (ProgressBar) findViewById(R.id.pbar_loading);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //判断文件完整存在的完整性
                FileInfo fileInfo = dataSource.getFileInfo();
                if (FileUtils.isFileExists(fileInfo.getFilePath())) {
                    getPresenter().previewImage(dataSource);
                }
            }
        });
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        mChatImage.setImageBitmap(null);
        mGifImageView.setBytes(null);
        mGifImageView.loadImageFrame(null);
//        mGifImageView.clear();
//        mContentLayout.setBackgroundResource(0);
    }

    @Override
    public void bindDataSource(int position, @NonNull final TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        ImageFileInfo fileInfo = (ImageFileInfo) dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            mChatImage.setError(R.mipmap.im_uikit_pic_failed);
            return;
        }

        //加载图片
        loadImage(fileInfo, dataSource);

        //闪信标识
        if (dataSource.isBomb()) {
            mBombFlagImg.setVisibility(View.VISIBLE);
        }
    }

    private void loadImage(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        /**
         * 1.本地文件存在，并且大小相等加载
         * 2.本地文件存在，文件大小不相等，等待回调加载
         * 3.本地文件不存在，但是出于下载状态，没有下载完成的情况下，转圈等待
         * 4.本地文件不存在，已经下载完成或者发送完完成，本地图片被删除，则显示默认图片
         * 5.本地文件不存在，正在发送的过程中，图片被删除，显示默认图片
         */
        @ConstDef.FileState
        int state = imageFileInfo.getFileState();
        switch (state) {
            case ConstDef.UPLOAD_DONE:
                loadImage(imageFileInfo);
                break;
            case ConstDef.UPLOAD_FAIL:
                loadImage(imageFileInfo);
                break;
            case ConstDef.UPLOAD_INACTIVE:
                loadImage(imageFileInfo);
                break;
            case ConstDef.UPLOAD_LOADING:
                loadImage(imageFileInfo);
                break;
            case ConstDef.UPLOAD_PAUSE:
                loadImage(imageFileInfo);
                break;
            case ConstDef.DONE:
                loadImage(imageFileInfo);
                break;
            case ConstDef.FAIL:
                imageSynchronousAccept(false);
                mChatImage.setError(R.mipmap.im_uikit_pic_default);
                break;
            case ConstDef.INACTIVE:
                imageSynchronousAccept(true);
                getPresenter().downLoadFile(dataSource, imageFileInfo);
                break;
            case ConstDef.LOADING:
                imageSynchronousAccept(true);
                getPresenter().downLoadFile(dataSource, imageFileInfo);
                break;
            case ConstDef.PAUSE:
                // TODO: 2018/9/25 暂定 暂停流程 
                imageSynchronousAccept(true);
                getPresenter().downLoadFile(dataSource, imageFileInfo);
                break;
        }
    }

    private void loadImage(ImageFileInfo imageFileInfo) {
        if (FileUtils.isFileExists(imageFileInfo.getFilePath())) {
            imageSynchronousAccept(false);
            loadImageUrl(imageFileInfo, dataSource);
        } else {
            imageSynchronousAccept(false);
            mChatImage.setError(R.mipmap.im_uikit_pic_default);
        }
    }


    /**
     * 加载URL指定图片
     *
     * @param imageFileInfo
     */
    private void loadImageUrl(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        String suffix = imageFileInfo.getSuffix();
        //fix bug 21243 by jyg 20171017
        if (imageFileInfo != null && ConstDef.GIF_TYPE.equalsIgnoreCase(suffix)
                && !TextUtils.isEmpty(imageFileInfo.getFilePath())) {
            final String urlGif = imageFileInfo.getFilePath();
            long fileSize = imageFileInfo.getFileSize();
            //fix bug 21243 by jyg 20171017
            mChatImage.setVisibility(View.GONE);
            mGifImageView.setVisibility(View.VISIBLE);
            /*if (isFileExist(urlGif)) {
                mGifImageView.loadImageFrame(urlGif);
                if (fileSize <= MAX_PLAY_GIF) {
                    Glide.with(getActivity())
                            .load(urlGif)
//                            .error(R.mipmap.im_uikit_pic_default)
 //                           .placeholder(R.mipmap.im_uikit_pic_default)
                            .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                            .listener(new RequestListener<String, GlideDrawable>() {
                                @Override
                                public boolean onException(Exception e, String s, Target<GlideDrawable> target, boolean b) {
                                    mGifImageView.loadImageFrame(urlGif);
                                    return true;
                                }

                                @Override
                                public boolean onResourceReady(GlideDrawable glideDrawable, String s, Target<GlideDrawable> target, boolean b, boolean b1) {
                                    return false;
                                }
                            })
                            .dontAnimate()
                            .into(mGifImageView);

                }
            }*/
            mGifImageView.loadImageFrame(urlGif);

            if (dataSource.isGifPlayed()) {
                mGifImageView.stopAnimation();
            } else {
                if (isFileExist(urlGif) &&fileSize <= MAX_PLAY_GIF ) {
                    try {
                        mGifImageView.loadImage(urlGif);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }
            }
        } else {
            mChatImage.setVisibility(View.VISIBLE);
            mGifImageView.setVisibility(View.GONE);
            mChatImage.loadImage(imageFileInfo.getFilePath(),ConstDef.SEND_IMAGE);
        }
    }

    private void imageSynchronousAccept(boolean accept) {
        if (accept) {
            progressBar.setVisibility(View.VISIBLE);
            mChatImage.setVisibility(View.GONE);
            mGifImageView.setVisibility(View.GONE);
        } else {
            progressBar.setVisibility(View.GONE);
            mChatImage.setVisibility(View.VISIBLE);
            mGifImageView.setVisibility(View.VISIBLE);
        }
    }

}
