package com.xdja.im.uikit.utils;

import android.text.TextUtils;

import com.xdja.google.gson.Gson;
import com.xdja.google.gson.reflect.TypeToken;
import com.xdja.im.uikit.ImUiKit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by xdjaxa on 2017/6/2.
 *
 */
public class AtAccountNickMap {
    private static String at = "at";
    private static Map<String,String> atAccountNick;
    private static Map<String,String> getAtAccountNick(){
        if(atAccountNick == null){
            // TODO: 2017/7/14
            synchronized (AtAccountNickMap.class){
                atAccountNick = new ConcurrentHashMap<>();
            }
        }
        return atAccountNick;
    }

    public static void putAccountNick(String groupId, String account, String nick) {
        if (!getAtAccountNick().containsKey(account)) {
            getAtAccountNick().put(account,nick);
        }
    }

    public static Map<String,String> getAccountMap() {
        return getAtAccountNick();
    }

    public static void clearAccountNick() {
        if(getAtAccountNick() != null && getAtAccountNick().size() > 0){
            getAtAccountNick().clear();
            atAccountNick = null;
        }
    }

    public static List<String> getAtAccount(String s , String imParterner) {
        if (TextUtils.isEmpty(s) || !s.contains("@")) return null;
        List<String> atAccount = new ArrayList<>();
      if (getAccountMap() != null && getAccountMap().size() != 0) {
          for (Map.Entry<String,String> map : getAccountMap().entrySet()) {
              if (s.contains("@" + map.getValue())) {
                  String account = map.getKey();
                  if (!atAccount.contains(account)) {
                      atAccount.add(account);
                  }
              }
          }
      } else {
          String listString = AtPreferencesUtils.getWrapper(ImUiKit.getInstance().getContext(),at).gPrefStringValue("at");
          if (TextUtils.isEmpty(listString)) return null;
          Map<String, String> atAccountList = new Gson().fromJson(listString, new TypeToken<Map<String, String>>() {
          }.getType());
          if (atAccountList != null) {
              for (Map.Entry<String, String> map1 : atAccountList.entrySet()) {
                  if (s.contains("@" + map1.getValue())) {
                      String account = map1.getKey();
                      if (!atAccount.contains(account)) {
                          atAccount.add(account);
                      }
                  }
              }
          }
      }
        return atAccount;
    }

    public static void saveAccount(String account , boolean isDraft) {
        if (isDraft) {
            AtPreferencesUtils.getWrapper(ImUiKit.getInstance().getContext(),at).setPreferenceStringValue("at",new Gson().toJson(atAccountNick));
        }
    }

    public static void clearAccount(String account) {
        AtPreferencesUtils.getWrapper(ImUiKit.getInstance().getContext(),at).setPreferenceStringValue("at",null);
    }

}
