package com.xdja.im.uikit.utils;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassUtils {


    private ClassUtils() {
    }

    private static final class Holder {
        private static final ClassUtils instance = new ClassUtils();
    }

    public static ClassUtils getInstance() {
        return Holder.instance;
    }

    /**
     * @param context     环境
     * @param excludeList 排除class列表
     * @return 返回AndroidManifest.xml中注册的所有Activity的class
     */
    public final List<Class> getActivitiesClass(Context context, List<Class> excludeList) {

        List<Class> returnClassList = new ArrayList<Class>();
        try {
            //Get all activity classes in the AndroidManifest.xml
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.GET_ACTIVITIES);
            if (packageInfo.activities != null) {
                LogUtil.d("Found " + packageInfo.activities.length + " activity in the AndrodiManifest.xml");
                for (ActivityInfo ai : packageInfo.activities) {
                    Class c;
                    try {
                        c = Class.forName(ai.name);
                        if (Activity.class.isAssignableFrom(c)) {
                            returnClassList.add(c);
                            LogUtil.d(ai.name + "...OK");
                        }
                    } catch (ClassNotFoundException e) {
                        LogUtil.d("Class Not Found:" + ai.name);
                    }
                }
                LogUtil.d("Filter out, left " + returnClassList.size() + " activity," + Arrays.toString(returnClassList.toArray()));

                //Exclude some activity classes
                if (excludeList != null) {
                    returnClassList.removeAll(excludeList);
                    LogUtil.d("Exclude " + excludeList.size() + " activity," + Arrays.toString(excludeList.toArray()));
                }
                LogUtil.d("Return " + returnClassList.size() + " activity," + Arrays.toString(returnClassList.toArray()));
            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        return returnClassList;
    }


    /**
     * @param context 上下文
     * @return 返回所有activity 名字
     */
    public final List<String> getActivitiesNames(Context context) {

        List<String> returnClassList = new ArrayList<>();
        try {
            //Get all activity classes in the AndroidManifest.xml
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.GET_ACTIVITIES);
            if (packageInfo.activities != null) {
                LogUtil.d("Found " + packageInfo.activities.length + " activity in the AndrodiManifest.xml");
                for (ActivityInfo ai : packageInfo.activities) {
                    Class c;
                    try {
                        c = Class.forName(ai.name);
                        if (Activity.class.isAssignableFrom(c)) {
                            returnClassList.add(ai.name);
                            LogUtil.d(ai.name + "...OK");
                        }
                    } catch (ClassNotFoundException e) {
                        LogUtil.d("Class Not Found:" + ai.name);
                    }
                }
                LogUtil.d("Filter out, left " + returnClassList.size() + " activity," + Arrays.toString(returnClassList.toArray()));
            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        return returnClassList;
    }


    /**
     * @param context   上下文
     * @param className activity类名
     * @return 根据类名判断是否注册
     */
    public boolean isRegisterActivity(Context context, String className) {
        boolean isRegister = false;
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.GET_ACTIVITIES);
            if (packageInfo.activities != null) {
                for (ActivityInfo ai : packageInfo.activities) {
                    String activityName = ai.name;
                    if (activityName.contains(className)) {
                        isRegister = true;
                    }
                }
            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return isRegister;
    }

}
