package com.xdja.im.uikit.utils;

import android.graphics.Bitmap;
import android.support.v4.util.LruCache;

import com.xdja.im.uikit.utils.image.BitmapUtils;

/**
 * @Package: com.xdja.im.uikit.cache
 * @Author: xdjaxa
 * @Creation: 2017-04-26 15:11
 * @Version V1.0
 * @Description:
 */
public class ImageCache {

    private ImageCache() {
        // use 1/8 of available heap size
        cache = new LruCache<String, Bitmap>((int) (Runtime.getRuntime().maxMemory() / 8)) {
            @Override
            protected int sizeOf(String key, Bitmap value) {
                return value.getRowBytes() * value.getHeight();
            }

            @Override
            protected void entryRemoved(boolean evicted, String key, Bitmap oldValue, Bitmap newValue) {
                super.entryRemoved(evicted, key, oldValue, newValue);
                if (evicted && oldValue != null){
                    //oldValue.recycle();
                    BitmapUtils.recycleBmp(oldValue);
                }
            }
        };
        smallCache = new LruCache<String, Bitmap>((int) (Runtime.getRuntime().maxMemory() / 8)) {
            @Override
            protected int sizeOf(String key, Bitmap value) {
                return value.getRowBytes() * value.getHeight();
            }
        };
    }

    private static class SingletonInstance{
        private static final ImageCache INSTANCE = new ImageCache();
    }

    public static ImageCache getInstance() {
        return SingletonInstance.INSTANCE;
    }

    private LruCache<String, Bitmap> cache = null;
    private LruCache<String, Bitmap> smallCache = null;

    /**
     * put bitmap to image cache
     * @param key
     * @param value
     * @return  the puts bitmap
     */
    public Bitmap put(String key, Bitmap value){
        return cache.put(key, value);
    }

    /**
     * return the bitmap
     * @param key
     * @return
     */
    public Bitmap get(String key){
        return cache.get(key);
    }
    /**
     * put bitmap to image cache
     * @param key
     * @param value
     * @return  the puts bitmap
     */
    public Bitmap smallCashPut(String key, Bitmap value){
        return smallCache.put(key, value);
    }

    /**
     * return the bitmap
     * @param key
     * @return
     */
    public Bitmap smallCashGet(String key){
        return smallCache.get(key);
    }

    /**
     * Clear all the cache
     */
    public void clearAllCache(){
        if (cache != null){
            cache.evictAll();
        }
    }

    /**
     * Clear all the small cache
     */
    public void clearAllsmallCache(){
        if (smallCache != null){
            smallCache.evictAll();
        }
    }
}
