package com.xdja.im.uikit.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.PromptPictureUtils;
import com.xdja.im.uikit.utils.image.BitmapUtils;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.io.File;

public class PromptPictureView extends LinearLayout {
    private ImageView mImageView;
    private String path;
    public PromptPictureView(Context context) {
        this(context, null);
    }

    public PromptPictureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PromptPictureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(context);
    }
    private void initView(Context context){
        View fastImageView = LayoutInflater.from(context).inflate(
                R.layout.im_uikit_fast_image_view, null);
        mImageView = (ImageView) fastImageView.findViewById(R.id.image_fast_send);
        this.addView(fastImageView);
    }
    public void loadImage(String url) {
        path = url;
        try {
            File file = new File(url);
            LogUtil.d("PromptPictureView url " + url);
            if (file.exists()) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = 8;
                Bitmap bmp = BitmapFactory.decodeFile(url, options);
                LogUtil.d("PromptPictureView bmp " + bmp);
                if (bmp == null) {
                    setVisibility(GONE);
                    PromptPictureUtils.getInstance().isImageChange = true;
                    return;
                }
                Bitmap bmpCrop = BitmapUtils.imageCrop(bmp);
                if (bmpCrop != null){
                    mImageView.setImageBitmap(bmpCrop);
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            setVisibility(GONE);
                        }
                    }, 10000);
                }else {
                    PromptPictureUtils.getInstance().isImageChange = true;
                    setVisibility(GONE);
                    return;
                }
                PromptPictureUtils.getInstance().isImageChange = false;
            } else {
                PromptPictureUtils.getInstance().isImageChange = true;
                setVisibility(GONE);
                return;
            }
        } catch (Exception e) {
            LogUtil.d("PromptPictureView exception" );
            PromptPictureUtils.getInstance().isImageChange = true;
            setVisibility(GONE);
            return;
        }
    }

    public String getPath() {
        return path;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        setVisibility(GONE);
    }


}
