package com.xdja.im.base.di.module;

import android.content.Context;

import com.xdja.im.base.di.DiConfig;
import com.xdja.im.base.di.scope.Scoped;

import androidx.fragment.app.Fragment;
import dagger.Module;
import dagger.Provides;

/**
 * @Package:com.sontak.mvpmodel.di.module
 * @Author:Lei
 * @Creation:2017-03-22 21:17
 * @Version 1.0
 * @Description:
 */
@Module
public class FragmentModule {

    private final Fragment fragment;

    public FragmentModule(Fragment fragment) {
        this.fragment = fragment;
    }

    @Scoped(DiConfig.CONTEXT_SCOPE_ACTIVITY)
    @Provides
    public Context provideContext() {
        return fragment.getContext();
    }
}
