package com.xdja.im.base.frame.presenter;

import android.os.Bundle;

import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

/**
 * @Package: com.xdja.im.base.frame.presenter
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:05
 * @Version V1.0
 * @Comment:通用Activity相关的Presenter
 */
public abstract class BaseActivityPresenter<P extends Presenter, V extends BaseView> extends AppCompatActivity {

    private V vu;

    private P presenter;

    public V getVu() {
        return vu;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        preBindView(savedInstanceState);
        try {
            vu = getVuClass().newInstance();
            vu.setPresenter(getPresenter());
            vu.setActivity(this);
            vu.init(getLayoutInflater(), null);
            setContentView(getVu().getView());

            onBindView(savedInstanceState);
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @NonNull
    protected abstract Class<? extends V> getVuClass();

    @NonNull
    protected abstract P getPresenter();

    protected void preBindView(@Nullable Bundle savedInstanceState) {

    }

    protected void onBindView(@Nullable Bundle savedInstanceState) {

    }
}
