package com.xdja.im.base.frame.presenter;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.view.FragmentBaseView;

/**
 * @Package: com.xdja.im.base.frame.presenter
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:13
 * @Version V1.0
 * @Comment:
 */
public abstract class BaseFragmentPresenter<P extends Presenter, V extends FragmentBaseView> extends Fragment {

    private V vu;

    public V getVu() {
        return vu;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        try {
            preBindView(savedInstanceState);

            vu = getVuClass().newInstance();
            vu.setPresenter(getPresenter());
            vu.setFragment(this);
            vu.setActivity(getActivity());
            vu.init(inflater, container);
            return getVu().getView();
        } catch (java.lang.InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        onBindView(savedInstanceState);
    }

    protected abstract Class<? extends V> getVuClass();

    @NonNull
    protected abstract P getPresenter();

    protected void preBindView(Bundle savedInstanceState) {

    }

    protected void onBindView(Bundle savedInstanceState) {

    }
}
