package com.xdja.im.base.frame.view;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.annotation.ContentView;

import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;

/**
 * @Package: com.xdja.im.base.frame.view
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:07
 * @Version V1.0
 * @Comment:
 */
public class SuperBaseView<P extends Presenter> implements BaseView<P> {

    private View view;
    private P presenter;

    private Activity activity;

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        ContentView contentView = getClass().getAnnotation(ContentView.class);
        if (contentView != null) {
            view = inflater.inflate(contentView.value(), container, false);
        } else {
            view = inflater.inflate(getLayoutRes(), container, false);
        }
        injectView();
    }

    @LayoutRes
    protected int getLayoutRes() {
        return 0;
    }

    protected void injectView() {
    }

    @Override
    public View getView() {
        return view;
    }

    public void setPresenter(P presenter) {
        this.presenter = presenter;
    }

    @Override
    public <A extends Activity> void setActivity(A activity) {
        this.activity = activity;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Context getContext() {
        return this.activity;
    }

    public P getPresenter() {
        return presenter;
    }

    public View findViewById(int resId) {
        return view.findViewById(resId);
    }

    /**
     * 获取资源实例
     *
     * @return
     */
    public Resources getResources() {
        return getContext().getResources();
    }

    /**
     * 获取String字符串
     *
     * @param res 字符串资源ID
     * @return 目标字符串
     */
    @NonNull
    public String getStringRes(@StringRes int res) {
        return getContext().getString(res);
    }

    /**
     * 获取Color颜色
     *
     * @param res 颜色资源ID
     * @return 目标颜色
     */
    public int getColorRes(@ColorRes int res) {
        return getContext().getResources().getColor(res);
    }

    /**
     * 获取Drawable
     *
     * @param res 图片资源ID
     * @return 目标Drawable
     */
    @Nullable
    public Drawable getDrawableRes(@DrawableRes int res) {
        return getContext().getResources().getDrawable(res);
    }

    /**
     * 获取Dimens
     *
     * @param res DimensID
     * @return 目标Dimens
     */
    @Nullable
    public int getDimensRes(@DimenRes int res) {
        return getContext().getResources().getDimensionPixelOffset(res);
    }

}
