package com.xdja.im.common.cache.entity;


import androidx.annotation.RawRes;

/**
 * @Package: com.xdja.im.common.cache.entity
 * @Author: xdjaxa
 * @Creation: 2017-05-04 15:50
 * @Version V1.0
 * @Description:账号信息
 */
public class UserEntity {

    /**
     * 业务相关帐号
     */
    private String account;
    /**
     * ticket
     */
    private String ticket;
    /**
     * clientId
     */
    private String clientId;

    private String fastDfsAddr;

    private String fastUserId;

    private String fastUserSecret;

    /**
     * 消息是否需要加密，默认关闭
     */
    private String ifEncrypt = "false";

    /**
     * @return {@link #account}
     */
    public String getAccount() {
        return account;
    }

    @RawRes
    private int keystoreId;

    private String keystorePsd;

    /**
     * 密信服务器证书
     */
    @RawRes
    private int mxKeystoreId;

    private String mxKeystorePsd;

    /**
     * 文件服务器证书
     */
    @RawRes
    private int fileKeystoreId;

    private String fileKeystorePsd;

    /**
     * @param account {@link #account}
     */
    public void setAccount(String account) {
        this.account = account;
    }

    public String getTicket() {
        return ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getFastDfsAddr() {
        return fastDfsAddr;
    }

    public void setFastDfsAddr(String fastDfsAddr) {
        this.fastDfsAddr = fastDfsAddr;
    }

    public String getFastUserId() {
        return fastUserId;
    }

    public void setFastUserId(String fastUserId) {
        this.fastUserId = fastUserId;
    }

    public String getFastUserSecret() {
        return fastUserSecret;
    }

    public void setFastUserSecret(String fastUserSecret) {
        this.fastUserSecret = fastUserSecret;
    }

    public String getIfEncrypt() {
        return ifEncrypt;
    }

    public void setIfEncrypt(String ifEncrypt) {
        this.ifEncrypt = ifEncrypt;
    }

    @RawRes
    public int getKeystoreId() {
        return keystoreId;
    }

    public void setKeystoreId(@RawRes int keystoreId) {
        this.keystoreId = keystoreId;
    }

    public String getKeystorePsd() {
        return keystorePsd;
    }

    public void setKeystorePsd(String keystorePsd) {
        this.keystorePsd = keystorePsd;
    }

    public int getFileKeystoreId() {
        return fileKeystoreId;
    }

    public void setFileKeystoreId(int fileKeystoreId) {
        this.fileKeystoreId = fileKeystoreId;
    }

    public String getFileKeystorePsd() {
        return fileKeystorePsd;
    }

    public void setFileKeystorePsd(String fileKeystorePsd) {
        this.fileKeystorePsd = fileKeystorePsd;
    }

    public int getMxKeystoreId() {
        return mxKeystoreId;
    }

    public void setMxKeystoreId(int mxKeystoreId) {
        this.mxKeystoreId = mxKeystoreId;
    }

    public String getMxKeystorePsd() {
        return mxKeystorePsd;
    }

    public void setMxKeystorePsd(String mxKeystorePsd) {
        this.mxKeystorePsd = mxKeystorePsd;
    }

    @Override
    public String toString() {
        return "UserEntity{" +
                "account='" + account + '\'' +
                ", ticket='" + ticket + '\'' +
                ", clientId='" + clientId + '\'' +
                '}';
    }
}
