package com.xdja.im.core.model.event;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.lib.file.bean.FileItem;

import java.util.List;

/**
 * @Package: com.xdja.im.core.model.event
 * @Author: xdjaxa
 * @Creation: 2017-04-17 11:04
 * @Version V1.0
 * @Description:OttO事件定义
 */
public class IMProxyEvent {

    /**
     * SDK初始化完成事件
     */
    public static class OnInitFinishedEvent {
        @Override
        public String toString() {
            return "OnInitFinishedEvent";
        }
    }

    public static class OnInitFailedEvent {
        @Override
        public String toString() {
            return "OnInitFailedEvent";
        }
    }

    /**
     * 已选文件事件
     */
    public static class FileSelectedEvent {
        FileItem fileInfo;

        public FileSelectedEvent(FileItem fileInfo) {
            this.fileInfo = fileInfo;
        }

        public FileItem getFileInfo() {
            return fileInfo;
        }

        public void setFileInfo(FileItem fileInfo) {
            this.fileInfo = fileInfo;
        }
    }

    /**
     * 已选文件事件
     */
    public static class FileUpdateEvent {

        public FileUpdateEvent() {
        }
    }

    /**
     * 聊天文件事件
     */
    public static class FileChatUpdateEvent {

        public FileChatUpdateEvent() {
        }
    }

    /**
     * 系统时间发生变化
     */
    public static class DataTimeChangedEvent {
    }

    /**
     * 网络状态上报
     */
    public static class NetworkStateEvent{
        private int state;

        public int getState() {
            return state;
        }

        public void setState(int state) {
            this.state = state;
        }
    }


    /**
     * 撤回成功的事件
     */
    public static class RecallMessageEvent {
        //撤回的会话信息
        private TalkSessionBean talkListBean;
        //撤回的单条消息
        private TalkMessageBean talkMessageBean;

        public TalkSessionBean getTalkSessionBean() {
            return talkListBean;
        }

        public void setTalkSessionBean(TalkSessionBean talkListBean) {
            this.talkListBean = talkListBean;
        }

        public TalkMessageBean getTalkMessageBean() {
            return talkMessageBean;
        }

        public void setTalkMessageBeans(TalkMessageBean talkMessageBean) {
            this.talkMessageBean = talkMessageBean;
        }
    }
    /**
     * 撤回失败的事件
     */
    public static class RecallFailEvent extends IMProxyMessageEvent.MessageEvent {
        //撤回的会话信息
        private TalkSessionBean talkListBean;
        //撤回失败的原因
        private int failCode;

        public int getFailCode() {
            return failCode;
        }

        public void setFailCode(int failCode) {
            this.failCode = failCode;
        }

        public TalkSessionBean getTalkSessionBean() {
            return talkListBean;
        }

        public void setTalkSessionBean(TalkSessionBean talkListBean) {
            this.talkListBean = talkListBean;
        }
    }

    /**
     * 会话相关的事件定义
     */
    public static class TalkEvent{
        /**
         * 会话ID
         */
        private String talkId;
        /**
         * 会话对象
         */
        private TalkSessionBean talkListBean;

        public String getTalkId() {
            return talkId;
        }

        public void setTalkId(String talkId) {
            this.talkId = talkId;
        }

        public TalkSessionBean getTalkListBean() {
            return talkListBean;
        }

        public void setTalkListBean(TalkSessionBean talkListBean) {
            this.talkListBean = talkListBean;
        }

        @Override
        public String toString() {
            return "TalkEvent{" +
                    "talkListBean=" + talkListBean +
                    ", talkAccount=" + talkId +
                    '}';
        }
    }

    /**
     * 消息相关的事件定义
     */
    public static class MessageEvent{
        /**
         * 聊天对象的账号
         */
        private String msgAccount;
        /**
         * 消息对象
         */
        private TalkMessageBean talkMessageBean;

        private List<TalkMessageBean> talkMessageBeansList;

        public String getMsgAccount() {
            return msgAccount;
        }

        public void setMsgAccount(String msgAccount) {
            this.msgAccount = msgAccount;
        }

        public TalkMessageBean getTalkMessageBean() {
            return talkMessageBean;
        }

        public void setTalkMessageBean(TalkMessageBean talkMessageBean) {
            this.talkMessageBean = talkMessageBean;
        }

        public List<TalkMessageBean> getTalkMessageBeansList() {
            return talkMessageBeansList;
        }

        public void setTalkMessageBeansList(List<TalkMessageBean> talkMessageBeansList) {
            this.talkMessageBeansList = talkMessageBeansList;
        }

        @Override
        public String toString() {
            return "MessageEvent{" +
                    "msgAccount=" + msgAccount +
                    ", talkMessageBean=" + talkMessageBean +
                    '}';
        }
    }

    /**
     * 创建新消息事件
     */
    public static class ReceiveNewMessageEvent extends MessageEvent{
        private TalkSessionBean talkListBean;

        public TalkSessionBean getTalkListBean() {
            return talkListBean;
        }

        public void setTalkListBean(TalkSessionBean talkListBean) {
            this.talkListBean = talkListBean;
        }

        @Override
        public String toString() {
            return "ReceiveNewMessageEvent{" +
                    "talkListBean=" + talkListBean +
                    '}';
        }
    }

    /**
     * 刷新单条会话事件定义
     */
    public static class RefreshSingleTalkEvent extends TalkEvent{
        public boolean isCreateNewTalk;
        public boolean isChatDetailRefresh;
        public boolean isTopSecretRefresh;

        public boolean isChatDetailRefresh() {
            return isChatDetailRefresh;
        }

        public void setChatDetailRefresh(boolean chatDetailRefresh) {
            isChatDetailRefresh = chatDetailRefresh;
        }

        public boolean isTopSecretRefresh() {
            return isTopSecretRefresh;
        }

        public void setTopSecretRefresh(boolean topSecretRefresh) {
            isTopSecretRefresh = topSecretRefresh;
        }
    }
}
