package com.xdja.im.core.model.message.file;

/**
 * @Package: com.xdja.im.core.model.message.file
 * @Author: xdjaxa
 * @Creation: 2017-04-18 19:43
 * @Version V1.0
 * @Description: 小视频文件信息
 */
public class VideoFileInfo extends FileInfo {

    /**
     * 小视频时长
     */
    private int amountOfTime;

    /**
     * 小视频大小
     */
    private long rawFileSize;

    /**
     * 视频高清缩略图
     */
    private FileInfo hdFileInfo;

    /**
     * 视频源文件
     */
    private FileInfo rawFileInfo;

    /**
     * 类型：缩略图，原视频文件
     */
    private int type;


    public VideoFileInfo() {

    }

    public int getAmountOfTime() {
        return amountOfTime;
    }

    public void setAmountOfTime(int amountOfTime) {
        this.amountOfTime = amountOfTime;
    }

    public long getRawFileSize() {
        return rawFileSize;
    }

    public void setRawFileSize(long rawFileSize) {
        this.rawFileSize = rawFileSize;
    }

    public FileInfo getHdFileInfo() {
        return hdFileInfo;
    }

    public void setHdFileInfo(FileInfo hdFileInfo) {
        this.hdFileInfo = hdFileInfo;
    }

    public FileInfo getRawFileInfo() {
        return rawFileInfo;
    }

    public void setRawFileInfo(FileInfo rawFileInfo) {
        this.rawFileInfo = rawFileInfo;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "VideoFileInfo{" +
                "amountOfTime=" + amountOfTime +
                ", rawFileSize=" + rawFileSize +
                ", hdFileInfo=" + hdFileInfo +
                ", rawFileInfo=" + rawFileInfo +
                "} " + super.toString();
    }
}
