package com.xdja.im.core.model.param;

import androidx.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Package: com.xdja.im.core.model.param
 * @Author: xdjaxa
 * @Creation: 2017-08-21 16:23
 * @Version V1.0
 * @Description:
 */
public class RemindAction {

    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {ACTION_CLOSE, ACTION_OPEN, ACTION_VOICE_CLOSE, ACTION_VOICE_OPEN,
            ACTION_VIBRATE_CLOSE, ACTION_VIBRATE_OPEN})
    public @interface Action {

    }

    /**
     * 关闭
     */
    public static final int ACTION_CLOSE = 0;
    /**
     * 开启
     */
    public static final int ACTION_OPEN = 1;
    /**
     * 关闭响铃
     */
    public static final int ACTION_VOICE_CLOSE = 2;
    /**
     * 打开响铃
     */
    public static final int ACTION_VOICE_OPEN = 3;
    /**
     * 打开震动
     */
    public static final int ACTION_VIBRATE_CLOSE = 4;
    /**
     * 关闭震动
     */
    public static final int ACTION_VIBRATE_OPEN = 5;
}
