package com.xdja.im.core.proxy;

import android.content.Context;
import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.base.executor.ThreadExecutor;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.callback.AccountCallback;
import com.xdja.im.core.callback.CommonCallback;
import com.xdja.im.core.callback.CustomComponentCallBack;
import com.xdja.im.core.callback.NotificationCallback;
import com.xdja.im.core.callback.NotificationChannelCallback;
import com.xdja.im.core.callback.OnAudioRecordCallback;
import com.xdja.im.core.callback.OnChatAt2GroupCallBack;
import com.xdja.im.core.callback.OnChatMeetCallBack;
import com.xdja.im.core.callback.OnChatSettingCallback;
import com.xdja.im.core.callback.OnChatUserInfoCallback;
import com.xdja.im.core.callback.OnImInitStateCallback;
import com.xdja.im.core.callback.OnOpenChatPageCallback;
import com.xdja.im.core.callback.OnShareOverCallback;
import com.xdja.im.core.callback.OnUserCanAccessToOptionCallBack;
import com.xdja.im.core.callback.SessionDeleteCallBack;
import com.xdja.im.core.callback.ShareSelectCallback;
import com.xdja.im.core.callback.UnReadMessageCallback;
import com.xdja.im.core.callback.UpDateSessionConfigCallback;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountAction;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.account.AccountType;
import com.xdja.im.core.model.event.IMContactEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.event.IMProxyUpdateSession;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.notify.NotificationBean;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.AtAccountNickMap;
import com.xdja.im.uikit.utils.log.LogUtil;

import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;

/**
 * @Package: com.xdja.im.core.proxy
 * @Author: xdjaxa
 * @Creation: 2017-06-26 8:49
 * @Version V1.0
 * @Description:
 */
public class IMUiKitProxyImpl implements IMUiKitProxy {

    private AccountCallback accountCallback;

    private NotificationCallback notificationCallback;

    private UnReadMessageCallback unReadMessageCallback;

    private OnChatSettingCallback onChatSettingCallback;

    private OnChatUserInfoCallback onChatUserInfoCallback;

    private OnOpenChatPageCallback onOpenChatPageCallback;

    private CommonCallback commonCallback;

    private OnChatMeetCallBack onChatMeetCallBack;

    private ShareSelectCallback shareSelectCallback;

    private OnAudioRecordCallback mAudioRecordCallback;

    private OnChatAt2GroupCallBack onChatAt2GroupCallBack;

    private OnShareOverCallback onShareOverCallback;

    private UpDateSessionConfigCallback upDateSessionConfigCallback;

    private CustomComponentCallBack mCustomComponentCallBack;

    private SessionDeleteCallBack mSessionDeleteCallBack;

    private OnUserCanAccessToOptionCallBack mOnUserCanAccessToOptionCallBack;

    private OnImInitStateCallback mOnImInitStateCallback;

    private NotificationChannelCallback mNotificationChannelCallback;

    private ThreadExecutor threadExecutor = new ThreadExecutor();

    private IMUiKitProxyImpl() {
    }


    private static class SingletonInstance {
        private static final IMUiKitProxyImpl mInstance = new IMUiKitProxyImpl();
    }

    public static IMUiKitProxyImpl getInstance() {
        return SingletonInstance.mInstance;
    }

    public void releaseProxy() {
        accountCallback = null;
        notificationCallback = null;
        unReadMessageCallback = null;
        onChatSettingCallback = null;
        commonCallback = null;
        onChatAt2GroupCallBack = null;
    }

    @Override
    public void setNotificationChannelCallback(NotificationChannelCallback callback) {
        this.mNotificationChannelCallback = callback;
    }

    @Override
    public void setAccountCallback(AccountCallback callback) {
        accountCallback = callback;
    }

    @Override
    public void setNotificationCallback(NotificationCallback callback) {
        notificationCallback = callback;
    }

    @Override
    public void setUnReadMessageCallback(UnReadMessageCallback callback) {
        unReadMessageCallback = callback;
    }

    @Override
    public void setOpenChatSettingCallback(OnChatSettingCallback callback) {
        onChatSettingCallback = callback;
    }

    @Override
    public void setOpenChatUserInfoCallback(OnChatUserInfoCallback callback) {
        onChatUserInfoCallback = callback;
    }

    @Override
    public void setOnOpenChatPageCallback(OnOpenChatPageCallback callback) {
        onOpenChatPageCallback = callback;
    }

    @Override
    public void setOnChatMeetCallBack(OnChatMeetCallBack callback) {
        onChatMeetCallBack = callback;
    }

    @Override
    public void setShareSelectCallback(ShareSelectCallback callback) {
        this.shareSelectCallback = callback;
    }

    @Override
    public void setOnAudioRecordCallback(OnAudioRecordCallback callback) {
        this.mAudioRecordCallback = callback;
    }

    @Override
    public void setCommonCallback(CommonCallback callback) {
        commonCallback = callback;
    }

    @Override
    public void registerOnShareOverCallback(OnShareOverCallback callback) {
        this.onShareOverCallback = callback;
    }

    @Override
    public void setUpDateSessionConfig(UpDateSessionConfigCallback upDateSessionConfig) {
        this.upDateSessionConfigCallback = upDateSessionConfig;
    }

    @Override
    public void setAt2GroupMembersCallback(OnChatAt2GroupCallBack callBack) {
        onChatAt2GroupCallBack = callBack;
    }

    @Override
    public void go2AtGroupMembersList(String groupId, String account) {
        if (onChatAt2GroupCallBack != null) {
            onChatAt2GroupCallBack.go2GroupMembersList(groupId, account);
        }
    }

    @Override
    public void notifyGroupMembsItemClick(String mGroupId, String account, String nickName) {
        IMContactEvent.AtGroupEvent event = new IMContactEvent.AtGroupEvent();
        event.setAccount(nickName);
        AtAccountNickMap.putAccountNick(mGroupId, account, nickName);
        BusProvider.getInstance().post(event);
    }

    @Override
    public void upDateConfigUi(@NonNull String type, @NonNull boolean setting, @NonNull String talkFlag) {
        if (upDateSessionConfigCallback != null) {
            upDateSessionConfigCallback.upDate(type, setting, talkFlag);
        }
    }

    @Override
    public void setCustomComponentCallBack(CustomComponentCallBack callBack) {
        this.mCustomComponentCallBack = callBack;
    }

    @Override
    public void setOnImInitStateCallback(OnImInitStateCallback callback) {
        this.mOnImInitStateCallback = callback;
    }

    @Override
    public void onInitFinished() {
        if (mOnImInitStateCallback != null) {
            mOnImInitStateCallback.onInitFinished();
        }
    }

    @Override
    public void onInitFailed() {
        if (mOnImInitStateCallback != null) {
            mOnImInitStateCallback.onInitFailed();
        }
    }

    @Override
    public int[] getCancelBottomMenuId(String sessionId, int sessionType) {
        if (onOpenChatPageCallback != null) {
            return onOpenChatPageCallback.getCancelBottomMenuId(sessionId, sessionType);
        }
        return new int[0];
    }

    @Override
    public String getChannelId() {
        if (mNotificationChannelCallback != null) {
            return mNotificationChannelCallback.getChannel();
        }
        return "my_imuikit_channel";
    }

    @Override
    public boolean audioIsWorking() {
        if (mAudioRecordCallback != null) {
            return mAudioRecordCallback.audioIsWorking();
        }
        return false;
    }

    @Override
    public void onCustomComponentCallBack(Context context, String talkId, int talkType, OptionBean optionBean) {
        if (mCustomComponentCallBack != null) {
            mCustomComponentCallBack.onComponentCallBack(context, talkId, talkType, optionBean);
        }
    }

    @Override
    public String onCustomMsgSessionShowTip(boolean isMine, String jsonContent) {
        if (mCustomComponentCallBack != null) {
            return mCustomComponentCallBack.onCustomMsgSessionShowTip(isMine, jsonContent);
        } else return jsonContent;
    }

    @Override
    public void setSessionDeleteCallBack(SessionDeleteCallBack sessionDeleteCallBack) {
        this.mSessionDeleteCallBack = sessionDeleteCallBack;
    }

    @Override
    public void onSessionDelete(TalkSessionBean sessionBean) {
        if (mSessionDeleteCallBack != null) {
            mSessionDeleteCallBack.onSessionDelete(sessionBean);
        }
    }

    @Override
    public void cancelNotification(String anto, int type) {
        if (commonCallback != null) {
            commonCallback.cancelNotification(anto, type);
        }
    }

    @Override
    public void setUserAccessToOption(OnUserCanAccessToOptionCallBack onUserCanAccessToOptionCallBack) {
        this.mOnUserCanAccessToOptionCallBack = onUserCanAccessToOptionCallBack;
    }

    @Override
    public boolean isAccessToOption(OptionBean optionBean) {
        if (mOnUserCanAccessToOptionCallBack != null) {
            return mOnUserCanAccessToOptionCallBack.isAccessToOption(optionBean);
        }
        return true;
    }

    @Override
    public void clearSessionCache() {
        DataCache.getInstance().clearAll();
        IMProxyUpdateSession updateSession = new IMProxyUpdateSession();
        BusProvider.getInstance().post(updateSession);
    }

    @Override
    public void getAccount(String account, final int type, Subscriber<AccountBean> subscriber) {
        Observable.just(account)
                .subscribeOn(threadExecutor.getScheduler())
                .flatMap(new Func1<String, Observable<AccountBean>>() {
                    @Override
                    public Observable<AccountBean> call(String account) {

                        AccountBean accountBean = null;
                        //缓存中获取
                        String sessionFlag = ToolUtils.getSessionTag(account, type);
                        accountBean = (AccountBean) DataCache.getInstance().get(sessionFlag);
                        if (accountBean != null) {
                            return Observable.just(accountBean);
                        }
                        //上层应用获取
                        if (accountCallback == null) {
                            return Observable.error(new IllegalArgumentException("Not register callback."));
                        }
                        AccountType accountType = AccountType.TYPE_P2P;
//                                ? AccountType.TYPE_P2P : AccountType.TYPE_P2G;
                        if (type == ConstDef.CHAT_TYPE_P2P) {
                            accountType = AccountType.TYPE_P2P;
                        } else if (type == ConstDef.CHAT_TYPE_P2G) {
                            accountType = AccountType.TYPE_P2G;
                        } else if (type == ConstDef.CHAT_TYPE_SYSTEM_INFO) {
                            accountType = AccountType.TYPE_SYS;
                        }
                        accountBean = accountCallback.getAccount(account, accountType);
                        if (accountBean == null) {
                            return Observable.error(new IllegalArgumentException("Get account failed."));
                        }
                        DataCache.getInstance().put(sessionFlag, accountBean);
                        return Observable.just(accountBean);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public AccountBean getAccount(String account, int type) {
        if (null == account) return null;
        //缓存中获取
        String sessionFlag = ToolUtils.getSessionTag(account, type);
        AccountBean accountBean = (AccountBean) DataCache.getInstance().get(sessionFlag);
        if (accountBean != null) {
            return accountBean;
        }
        //上层应用获取
        if (accountCallback == null) {
            LogUtil.e(this.getClass().getName(), "can't get account info, accountCallback is null");
            return null;
        }
        AccountType accountType = AccountType.TYPE_P2P;
//                                ? AccountType.TYPE_P2P : AccountType.TYPE_P2G;
        if (type == ConstDef.CHAT_TYPE_P2P) {
            accountType = AccountType.TYPE_P2P;
        } else if (type == ConstDef.CHAT_TYPE_P2G) {
            accountType = AccountType.TYPE_P2G;
        } else if (type == ConstDef.CHAT_TYPE_SYSTEM_INFO) {
            accountType = AccountType.TYPE_SYS;
        }
        accountBean = accountCallback.getAccount(account, accountType);
        if (accountBean == null) {
            LogUtil.e(this.getClass().getName(), "account info is null, from accountCallback");
            return null;
        }
        DataCache.getInstance().put(sessionFlag, accountBean);
        return accountBean;
    }

    @Override
    public void notifyAccountChanged(String account, AccountAction action) {
        if (TextUtils.isEmpty(account)) {
            LogUtil.e("ERROR: notify account changed, but account is empty.");
            return;
        }
        LogUtil.d("Notify account Changed account " + account + "(" + action + ")");

        String sFlag = ToolUtils.getSessionTag(account, ConstDef.CHAT_TYPE_P2P);
        switch (action) {
            case ACTION_UPDATE: //更新联系人信息
                DataCache.getInstance().remove(sFlag);
                BusProvider.getInstance().post(new IMProxySessionEvent.RefreshSessionListEvent());
                break;

            case ACTION_DELETE: //删除联系人信息
                DataCache.getInstance().remove(sFlag);
                IMProxySessionEvent.DeleteSessionEvent deleteSessionEvent = new IMProxySessionEvent.DeleteSessionEvent();
                TalkSessionBean talkSessionBean = new TalkSessionBean();
                talkSessionBean.setTalkerAccount(account);
                talkSessionBean.setTalkType(ConstDef.CHAT_TYPE_P2P);
                deleteSessionEvent.setSessionBean(talkSessionBean);
                BusProvider.getInstance().post(deleteSessionEvent);
                break;
        }
    }

    @Override
    public boolean notify(TalkSessionBean sessionBean, int newMsgCnt, boolean isDisturb) {

        if (notificationCallback == null) {
            LogUtil.d("Notify callback is null.");
            return false;
        }

        //对外接口数据实体类
        NotificationBean notificationBean = new NotificationBean();
        notificationBean.setAccount(sessionBean.getTalkerAccount());
        notificationBean.setTalkId(sessionBean.getTalkFlag());
        notificationBean.setTalkType(sessionBean.getTalkType());
        notificationBean.setMsgCount(newMsgCnt);

        TalkMessageBean talkMessageBean = sessionBean.getLastMsg();
        if (talkMessageBean == null || talkMessageBean.isMine()) {
            LogUtil.w("This notify come form myself, so return!!");
            return true;
        }
        String content = talkMessageBean.getContent();
        switch (talkMessageBean.getMessageType()) {
            case ConstDef.MSG_TYPE_VOICE:
                content = CommonTool.getString(R.string.im_uikit_voice);
                break;
            case ConstDef.MSG_TYPE_PHOTO:
                content = CommonTool.getString(R.string.im_uikit_image);
                break;
            case ConstDef.MSG_TYPE_VIDEO:
                content = CommonTool.getString(R.string.im_uikit_video);
                break;
            case ConstDef.MSG_TYPE_FILE:
                content = CommonTool.getString(R.string.im_uikit_file);
                break;
        }
        notificationBean.setContent(content);
        notificationBean.setDisturb(isDisturb);
        notificationBean.setShowTime(sessionBean.getLastTime());

        LogUtil.d("Start to notify..." + notificationBean.toString());
        notificationCallback.notify(notificationBean);
        return true;
    }

    @Override
    public void updateUnReadMessageCount(int count) {
        if (unReadMessageCallback == null) {
            LogUtil.d("UnReadMessage callback is null.");
            return;
        }
        LogUtil.d("Update unRead message " + count);
        unReadMessageCallback.onRefresh(count);
    }

    @Override
    public boolean openChatSettingCallback(String sessionId, int sessionType) {
        if (onChatSettingCallback == null) {
            LogUtil.d("open chat setting callback is null.");
            return false;
        }
        onChatSettingCallback.openSetting(sessionId, sessionType);
        return true;
    }

    @Override
    public boolean openChatUserInfoCallback(String account) {
        if (onChatUserInfoCallback == null) {
            LogUtil.d("open chat setting callback is null.");
            return false;
        }
        onChatUserInfoCallback.openUserInfo(account);
        return true;
    }

    @Override
    public boolean isShowGroupSetting(String groupId) {
        if (onChatSettingCallback != null) {
            return onChatSettingCallback.isGroupMember(groupId);
        }
        return false;
    }

    @Override
    public void startCallback(String atNo) {
        if (commonCallback != null) {
            commonCallback.startCallback(atNo);
        }
    }

    @Override
    public void startCallback(String atNo, int type) {
        if (commonCallback != null) {
            commonCallback.startCallback(atNo, type);
        }
    }

    @Override
    public void startVoice(String atNo, int type) {
        if (commonCallback != null) {
            commonCallback.startVoice(atNo, type);
        }
    }

    @Override
    public void addMeetting(String account, String groupId) {
        if (onChatMeetCallBack != null) {
            onChatMeetCallBack.addMeeting(account, groupId);
        }
    }

    @Override
    public void callSessionContact(Context context, int type, String action) {
        if (shareSelectCallback != null) {
            shareSelectCallback.callSessionContact(context, type, action);
        }
    }

    @Override
    public void callSessionSearch(Context context, String key, int type, String action) {
        if (shareSelectCallback != null) {
            shareSelectCallback.callSessionSearch(context, key, type, action);
        }
    }

    @Override
    public void shareOverCallback(Context context) {
        if (onShareOverCallback != null) {
            onShareOverCallback.shareOverCallback(context);
        }
    }

    @Override
    public void startLocation(String atNo) {
        if (commonCallback != null) {
            commonCallback.startLocation(atNo);
        }
    }
}
