package com.xdja.im.core.push;

import android.content.Context;
import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.xdja.im.common.persistent.PropertyUtil;
import com.xdja.im.lib.filemanage.util.TextUtil;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.pushsdk.PushClient;

import java.util.ArrayList;

/**
 * @Package: com.xdja.im.core.push
 * @Author: xdjaxa
 * @Creation: 2017-05-08 9:58
 * @Version V1.0
 * @Description:
 */
public class PushControllerImp implements PushController {

    public static final String TOPIC_IM = "/im";

    public static String clientId;

    public static String subTopic;

    /**
     * 框架订阅的主题
     */
    private ArrayList<String> mTopics;

    private static final String TOPIC_MX = "/mxs";

    private PushControllerImp() {
    }

    private static class SingletonInstance {
        private static final PushControllerImp mInstance = new PushControllerImp();
    }

    public static PushControllerImp getInstance() {
        return SingletonInstance.mInstance;
    }


    @Override
    public void startPush(String appId, String userId, String key) {
        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("ERROR: client id is null." + clientId);
            return;
        }
        if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(userId)) {
            throw new IllegalArgumentException("para is null");
        }

        this.subTopic = appId + "/" + userId + TOPIC_IM;
        subTopics(context,appId,userId);
    }

    @Override
    public boolean releasePush() {
        LogUtil.d("releaseProxy push...");

        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("Release push failed. context is null.");
            return false;
        }
        PushClient.unsubscribe(context,mTopics);
        int release = PushClient.release(context);
        return release == 0;
    }

    private void subTopics(@NonNull Context context, @NonNull String appId, @NonNull String userId) {
        mTopics = new ArrayList<>();
        mTopics.add(appId + "/" + userId + TOPIC_IM);
        mTopics.add(appId + "/" + userId + TOPIC_MX);
        PushClient.subTopic(context, mTopics);
    }

}
