package com.xdja.im.core.repository.impl.im;

import android.content.Context;

import com.xdja.im.base.di.DiConfig;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.repository.interf.im.IMProxyCallBack;
import com.xdja.im.uikit.utils.NetworkHelper;

import java.util.List;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.core.repository.impl.im
 * @Author: xdjaxa
 * @Creation: 2017-04-11 17:15
 * @Version V1.0
 * @Description:向业务层回调的接口
 */
public class IMProxyCallBackImpl implements IMProxyCallBack {

    private Context context;

    private UserCache userCache;

    @Inject
    public IMProxyCallBackImpl(@Scoped(value = DiConfig.CONTEXT_SCOPE_APP) Context context,
                               UserCache userCache) {
        this.context = context;
        this.userCache = userCache;
    }

    @Override
    public int onInitFinished() {
        try {
            //构建事件对象
            IMProxyEvent.OnInitFinishedEvent onInitFinishedEvent =
                    new IMProxyEvent.OnInitFinishedEvent();
            //发送事件
            BusProvider.getInstance().post(onInitFinishedEvent);

            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception e) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onInitFailed() {
        try {
            //构建事件对象
            IMProxyEvent.OnInitFailedEvent onInitFailedEvent =
                    new IMProxyEvent.OnInitFailedEvent();
            //发送事件
            BusProvider.getInstance().post(onInitFailedEvent);

            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception e) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onCreateNewSession(TalkSessionBean talkSessionBean) {
        try {
            //构建事件对象
            IMProxySessionEvent.CreateNewSessionEvent talkEvent
                    = new IMProxySessionEvent.CreateNewSessionEvent();
            talkEvent.setTalkId(talkSessionBean.getTalkerAccount());
            talkEvent.setSessionBean(talkSessionBean);
            //发送事件
            BusProvider.getInstance().post(talkEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onDeleteSession(TalkSessionBean talkSessionBean) {
        try {
            //构建事件对象
            IMProxySessionEvent.DeleteSessionEvent talkEvent
                    = new IMProxySessionEvent.DeleteSessionEvent();
            talkEvent.setTalkId(talkSessionBean.getTalkerAccount());
            talkEvent.setSessionBean(talkSessionBean);
            //发送事件
            BusProvider.getInstance().post(talkEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onRefreshSession(TalkSessionBean talkSessionBean) {
        try {
            //构建事件对象
            IMProxySessionEvent.RefreshSessionEvent talkEvent
                    = new IMProxySessionEvent.RefreshSessionEvent();
            talkEvent.setTalkId(talkSessionBean.getTalkerAccount());
            talkEvent.setSessionBean(talkSessionBean);

            //发送事件
            BusProvider.getInstance().post(talkEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception e) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onReceiveNewMessage(String account, List<TalkMessageBean> talkMessageBean) {
        try {

            IMProxyMessageEvent.ReceiveNewMessageEvent messageEvent
                    = new IMProxyMessageEvent.ReceiveNewMessageEvent();
            messageEvent.setMsgAccount(account);
            messageEvent.setTalkMessageList(talkMessageBean);


            BusProvider.getInstance().post(messageEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onRemainNewMessage(TalkSessionBean session, List<TalkMessageBean> talkMessageBean) {
        try {
            IMProxyMessageEvent.NewMsgComeEvent event = new IMProxyMessageEvent.NewMsgComeEvent();
            event.setListBean(session);
            event.setBeans(talkMessageBean);

            //发送事件
            BusProvider.getInstance().post(event);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onDeleteMessage(String account, TalkMessageBean talkMessageBean) {
        try {
            //构建事件对象
            IMProxyMessageEvent.DeleteMessageEvent messageEvent
                    = new IMProxyMessageEvent.DeleteMessageEvent();
            messageEvent.setMsgAccount(account);
            messageEvent.setTalkMessageBean(talkMessageBean);

            //发送事件
            BusProvider.getInstance().post(messageEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onRefreshMessage(String account, TalkMessageBean talkMessageBean) {
        try {
            //构建事件对象
            IMProxyMessageEvent.RefreshMessageEvent messageEvent
                    = new IMProxyMessageEvent.RefreshMessageEvent();
            messageEvent.setMsgAccount(account);
            messageEvent.setTalkMessageBean(talkMessageBean);

            //发送事件
            BusProvider.getInstance().post(messageEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int refreshMessageList() {
        try {
            //构建事件对象
            IMProxyMessageEvent.RefreshMessageListEvent messageEvent
                    = new IMProxyMessageEvent.RefreshMessageListEvent();

            //发送事件
            BusProvider.getInstance().post(messageEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onSendFileProgressUpdate(String talkId, long msgId, FileInfo fileInfo, int progress) {
        try {
            //构建事件对象
            IMProxyFileEvent.SendFileProgressUpdateEvent fileEvent
                    = new IMProxyFileEvent.SendFileProgressUpdateEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            fileEvent.setPercent(progress);
            fileEvent.setFileProperty(fileInfo.getFileProperty());
            //发送事件
            BusProvider.getInstance().post(fileEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onSendFileFinished(String talkId, long msgId, FileInfo fileInfo) {
        try {
            //构建事件对象
            IMProxyFileEvent.SendFileFinishedEvent fileEvent
                    = new IMProxyFileEvent.SendFileFinishedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            //发送事件
            BusProvider.getInstance().post(fileEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onSendFileFailed(String talkId, long msgId, FileInfo fileInfo, int code) {
        try {
            //构建事件对象
            IMProxyFileEvent.SendFileFailedEvent fileEvent
                    = new IMProxyFileEvent.SendFileFailedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            //发送事件
            BusProvider.getInstance().post(fileEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onReceiveFileProgressUpdate(String talkId, long msgId, FileInfo fileInfo, int progress) {
        try {
            //构建事件对象
            IMProxyFileEvent.ReceiveFileProgressUpdateEvent fileEvent
                    = new IMProxyFileEvent.ReceiveFileProgressUpdateEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            fileEvent.setPercent(progress);
            //发送事件
            BusProvider.getInstance().post(fileEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onReceiveFileFinished(String talkId, long msgId, FileInfo fileInfo) {
        try {
            //构建事件对象
            IMProxyFileEvent.ReceiveFileFinishedEvent fileEvent
                    = new IMProxyFileEvent.ReceiveFileFinishedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            //发送事件
            BusProvider.getInstance().post(fileEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onReceiveFileFailed(String talkId, long msgId, FileInfo fileInfo, int code) {
        try {
            //构建事件对象
            IMProxyFileEvent.ReceiveFileFailedEvent fileEvent =
                    new IMProxyFileEvent.ReceiveFileFailedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            //发送事件
            BusProvider.getInstance().post(fileEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onReceiveFilePaused(String talkId, long msgId, FileInfo fileInfo) {
        try {
            //构建事件对象
            IMProxyFileEvent.ReceiveFilePausedEvent fileEvent =
                    new IMProxyFileEvent.ReceiveFilePausedEvent();
            fileEvent.setFileInfo(fileInfo);
            fileEvent.setFileId(fileInfo.getTalkMessageId());
            fileEvent.setAttachedMsgId(msgId);
            fileEvent.setAttachedTalkId(talkId);
            //发送事件
            BusProvider.getInstance().post(fileEvent);
            //返回正确处理结果
            return ConstDef.CALLBACK_HANDLED;
        } catch (Exception ex) {
            //处理异常信息
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int onRecallSuccess(TalkSessionBean talkSessionBean, TalkMessageBean talkMessageBean) {
        try {
            IMProxyEvent.RecallMessageEvent recallMessageEvent =
                    new IMProxyEvent.RecallMessageEvent();
            recallMessageEvent.setTalkSessionBean(talkSessionBean);
            recallMessageEvent.setTalkMessageBeans(talkMessageBean);
            BusProvider.getInstance().post(recallMessageEvent);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ConstDef.CALLBACK_HANDLED;
    }

    @Override
    public int onRecallFail(TalkSessionBean talkSessionBean, TalkMessageBean talkMessageBean, int failCode) {
        try {
            IMProxyEvent.RecallFailEvent recallFailEvent =
                    new IMProxyEvent.RecallFailEvent();
            recallFailEvent.setTalkSessionBean(talkSessionBean);
            recallFailEvent.setTalkMessageBean(talkMessageBean);
            BusProvider.getInstance().post(recallFailEvent);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ConstDef.CALLBACK_HANDLED;

    }

    @Override
    public int onReceiveNetState(int netState) {
        try {
            NetworkHelper.getHelper().receiveNetState(netState);
            if (NetworkHelper.getHelper().networkChanged()) {
                IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                networkStateEvent.setState(netState);
                BusProvider.getInstance().post(networkStateEvent);
                return ConstDef.CALLBACK_HANDLED;
            } else {
                return ConstDef.CALLBACK_NOT_HANDLED;
            }
        } catch (Exception ex) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }
}
