package com.xdja.im.core.repository.interf;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.vu.ChatListVu;

import java.util.List;

/**
 * Created by Administrator on 2017/12/28.
 */

public interface ChatListCallBack {

    /**
     * 聊天对象账号id
     */
    String getTalkId();
    /**
     * 会话类型
     */
    int getTalkType();

    List<TalkMessageBean> getListTalkMessageBean();
    /**
     *
     * @return CancelBottomPopMenuIdArray
     */
    int[] getCancelBottomPopMenuIdArray();


    /**
     *  初始化参数 arguments
     */
    void initChatPram(Bundle arguments,ChatListVu vu,ChatListPresenter presenter);


    void setTitle();
    /**
     * 获取权限
     * @param context
     */
    void requestPermissions(Activity context);


    /**
     * 构建适配器
     * @return
     */
    ChatListAdapter buildAdapter();

    void notifyDataSetChanged();

    String getAccount();

    /**
     * 清除适配器
     * @return
     */
    void clearAdapter();

    /**
     * 获取未读消息
     */
    void getUnReadMsg();

    /**
     * 加载当前会话中的所有聊天消息
     *
     * @param msgId 消息id，如果为0，则表示拉取最新消息
     */
    void loadMessageList(long msgId);

    /**
     * 加载当前会话中的所有聊天消息
     *
     * @param msgId 消息id，如果为0，则表示拉取最新消息
     */
    void loadMessageList(long msgId,int PAGE_SIZE);

    void downRefreshList();
    /**
     * 加载Options数据
     */
    void startLoadOptions(Context context);

    /**
     * 退出聊天界面，通知更新会话内容
     */
    void notifyUpdateLastSession();

    /**
     * 发送通知事件
     *
     * @param bean
     */
    void sendNotifyUpdateEvent(TalkSessionBean bean);

    /**
     * 获取草稿信息
     */
    void getDraftContent();

    /**
     * 更新草稿信息
     *
     * @param draftContent
     */
    void updateDraftContent(String draftContent);

    /**
     * 保存草稿信息
     *
     * @param draftContent
     * @param draftTime
     */
    void saveDraft(String draftContent, long draftTime);

    /**
     * 清除草稿信息
     */
     void clearDraft(final long draftTime);

    /**
     * 清除未读消息标识
     */
    void clearUnReadMsgCount();

    /**
     * @用户
     */
    void onLongClickAtUser(int type,String groupId, String account,String name);

    /**
     * 发送消息
     */
    void sendTextMessage(String message);
    void sendCustomMessage(String message);

    void sendAtTextMessage(String message,List<String> atAccount);
    /**
     * 发送文件消息
     */
    void sendFileMessage(List<FileInfo> fileList);

    /**
     * 发送声音消息
     */
    void sendVoiceMessage(String path, int seconds);


    Intent buildIntent(Context context,OptionBean optionBean);

    void startToOptionView(Activity context,int position, OptionBean optionBean);

    /**
     * 相册返回值处理
     *
     * @param data
     */
    void handleAlbumResult(Intent data);

    /**
     * 拍照返回值处理
     *
     * @param data
     */
    void handleCameraResult(Intent data);

    /**
     * 视频录制返回值处理
     *
     * @param data
     */
    void handleVideoRecorderResult(Intent data);

    /**
     * 文件选择返回值处理
     *
     * @param data
     */
    void handleFileResult(Intent data);


    /**
     * 文件返回值结果处理
     *
     * @param data
     */
    void handleFileLoadResult(Intent data);

    /**
     * 事件和消息匹配
     *
     * @param messageId 事件ID
     * @return
     */
    int mathMessage(long messageId);

    /**
     * 更新消息文件信息
     *
     * @param position
     * @param fileInfo
     */
    void updateFileInfo(int position, FileInfo fileInfo);
    /**
     * 更新文件传输进度
     */
    void updateFileTranslateSize();

    /**
     * 更改消息状态
     *
     * @param bean 消息体
     */
    void changeMsgState(TalkMessageBean bean);

    /**
     * 收到新消息，更新列表
     *
     * @param talkMessageList
     */
    void addNewMessageToList(List<TalkMessageBean> talkMessageList);


    void setAtType();

    void setNoReadNumber();

    void syncServerTime();
}
