package com.xdja.im.core.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.utils.PingNet;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.NetworkUtil;


/**
 * @Package: com.xdja.im.core.service
 * @Author: xdjaxa
 * @Creation: 2017-06-29 15:29
 * @Version V1.0
 * @Description:
 */
public class NetworkStatusReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            String state = intent.getStringExtra(ConstDef.PUSH_CODE);
            if (ConstDef.PUSH_CONNECTED.equals(state) && ImUiKit.getInstance().isInit()) {
                Intent serviceIntent = new Intent(context, KitService.class);
                serviceIntent.setAction(ConstDef.IM_PUSH_STATE);
                // start modify by lyj 解决8.0服务问题 2020.05.25
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    context.startForegroundService(serviceIntent);
                }else{
                    context.startService(serviceIntent);
                }
                // end
            }
            //dealNetState(context);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dealNetState(Context context) {
        if (ImUiKit.getInstance().isInit()) {
            if (NetworkUtil.isNetworkConnected(context)) {
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        if (isNetConnected()) {
                            try {
                                NetworkHelper.getHelper().receiveNetState(NetworkHelper.NET_OK);
                                IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                                networkStateEvent.setState(NetworkHelper.NET_OK);
                                BusProvider.getInstance().post(networkStateEvent);
                                LogUtil.d("NetworkHelper.NET_OK");
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {//NO_SERVER
                            try {
                                NetworkHelper.getHelper().receiveNetState(NetworkHelper.NO_SERVER);
                                IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                                networkStateEvent.setState(NetworkHelper.NO_SERVER);
                                BusProvider.getInstance().post(networkStateEvent);
                                LogUtil.d("NetworkHelper.NO_SERVER");
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }).start();
            } else {//NetworkHelper.NET_DISABLED
                try {
                    NetworkHelper.getHelper().receiveNetState(NetworkHelper.NET_DISABLED);
                    IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                    networkStateEvent.setState(NetworkHelper.NET_DISABLED);
                    BusProvider.getInstance().post(networkStateEvent);
                    LogUtil.d("NetworkHelper.NET_DISABLED");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                NetworkHelper.getHelper().receiveNetState(NetworkHelper.NET_OK);
                IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                networkStateEvent.setState(NetworkHelper.NET_OK);
                BusProvider.getInstance().post(networkStateEvent);
                LogUtil.d("NetworkHelper.NET_OK");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized boolean isNetConnected() {
        try {
            String imUrl = ImUiKit.getInstance().getComponent().configCache().getServer().getImUrl();
//            float pingFloat = PingNet.getPacketLossFloat(imUrl, 2, 300);
            int state = PingNet.pingIpAddress(imUrl);
            LogUtil.d("state" + state);
            return state == 0;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}
