package com.xdja.im.core.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.util.Log;

import java.util.List;

/**
 * Created by yangpeng on 2015/4/14.
 */
public class CommonUtils {

    private static final String TAG = "CommonUtils";

    public static boolean isServiceRunning(Context context, String serviceName) {
        boolean isRunning = false;
        if (context == null || serviceName == null || context.getPackageName() == null)
            return isRunning;
        ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningServiceInfo> arrayList = activityManager.getRunningServices(100);
        if (arrayList == null || arrayList.isEmpty()) return isRunning;
        for (int i = 0, n = arrayList.size(); i < n; i++) {
            if (serviceName.equals(arrayList.get(i).service.getClassName().toString())) {
                isRunning = true;
                break;
            }
        }
        Log.d(TAG, "H>>> ServiceRunning : " + serviceName + " , " + isRunning);
        return isRunning;
    }
}