package com.xdja.im.lib.action.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.R;

import java.util.List;

import androidx.recyclerview.widget.RecyclerView;

/**
 * @Package: com.xdja.im.lib.action.adapter
 * @Author: xdjaxa
 * @Creation: 2017-07-06 14:06
 * @Version V1.0
 * @Description:
 */
public class ChatActionAdapter extends RecyclerView.Adapter<ChatActionViewHolder> {

    private Context mContext;

    private List<OptionBean> mOptions;

    private Callback mCallback;

    public ChatActionAdapter(Context context, List<OptionBean> options, Callback callback) {
        this.mContext = context;
        this.mOptions = options;
        this.mCallback = callback;
    }

    @Override
    public int getItemCount() {
        return mOptions == null ? 0 : mOptions.size();
    }

    @Override
    public ChatActionViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(parent.getContext());
        View itemView = inflater.inflate(R.layout.im_uikit_item_chat_action_menu, parent, false);
        return new ChatActionViewHolder(mContext, itemView);
    }

    @Override
    public void onBindViewHolder(ChatActionViewHolder holder, final int position) {
        if (holder != null) {
            holder.bindData(mOptions.get(position));
            holder.getItemView().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mCallback != null) {
                        mCallback.onItemClickListener(position);
                    }
                }
            });
        }
    }

    public interface Callback {

        /**
         * Item点击事件
         *
         * @param position
         */
        void onItemClickListener(int position);
    }
}
