package com.xdja.im.lib.album.bean;

import androidx.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Package: com.xdja.im.lib.album.bean
 * @Author: xdjaxa
 * @Creation: 2017-04-24 16:16
 * @Version V1.0
 * @Description:图片类型（包括图片和视频缩略图，如有相机，一般第一个位置显示相机）
 */
public class PickerType {

    /**
     * 图片
     */
    public static final int TYPE_IMAGE = 0X00;

    /**
     * 视频
     */
    public static final int TYPE_VIDEO = 0x01;

    /**
     * 相机
     */
    public static final int TYPE_CAMERA = 0X02;

    @IntDef({TYPE_IMAGE, TYPE_VIDEO, TYPE_CAMERA})
    @Retention(RetentionPolicy.SOURCE)
    @interface TYPE {
    }
}
