package com.xdja.im.lib.album.ui.view;

import android.graphics.Color;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;

import com.xdja.im.lib.album.ImageDataSource;
import com.xdja.im.lib.album.ImagePickerConfig;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.ui.adapter.ImagePickerAdapter;
import com.xdja.im.lib.album.ui.presenter.ImagePickerPresenter;
import com.xdja.im.lib.album.ui.view.vu.ImagePickerVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImActivitySuperView;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * @Package:com.xdja.im.lib.album.ui
 * @Author:Lei
 * @Creation:2017-04-23 12:27
 * @Version 1.0
 * @Description:
 */
public class ViewImagePicker extends ImActivitySuperView<ImagePickerPresenter>
        implements ImagePickerVu {

    /**
     * 图片显示布局
     */
    private RelativeLayout mContainerLayout;
    /**
     * 列表显示控件
     */
    private RecyclerView mAlbumListRv;

    /**
     * 预览控件
     */
    private Button mPreviewBtn;

    /**
     * 发送按钮控件
     */
    private Button mSendBtn;

    /**
     * 数据为空显示
     */
    private LinearLayout mEmptyLayout;
    /**
     * 底部控件
     */
    private RelativeLayout mBottomLayout;
    /**
     * 加载控件
     */
    private ProgressBar mLoadingPBar;

    /**
     * 每行显示个数
     */
    private int mColumnNum;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_image_picker;
    }

    @Override
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    protected int getToolbarTitle() {
        return R.string.im_uikit_selest_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        initView();
        mColumnNum = ImagePickerManager.getInstance().getConfig().getColumnNum();
        mAlbumListRv.setLayoutManager(new GridLayoutManager(getContext(), mColumnNum));

        mPreviewBtn.setEnabled(false);
        mSendBtn.setEnabled(false);

        mSendBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().sendImage(ImageDataSource.getInstance().getSelects());
            }
        });
        mPreviewBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().preView();
            }
        });
    }

    /**
     * 控件初始化
     */
    private void initView() {
        mContainerLayout = (RelativeLayout) findViewById(R.id.layout_container);
        mAlbumListRv = (RecyclerView) findViewById(R.id.rv_album_list);
        mPreviewBtn = (Button) findViewById(R.id.btn_preview);
        mSendBtn = (Button) findViewById(R.id.btn_send);
        mEmptyLayout = (LinearLayout) findViewById(R.id.layout_album_empty);
        mLoadingPBar = (ProgressBar) findViewById(R.id.pbar_loading);
        mBottomLayout = (RelativeLayout) findViewById(R.id.layout_bottom);
    }

    @Override
    public void setAdapter(ImagePickerAdapter adapter) {
        mAlbumListRv.setAdapter(adapter);
        adapter.notifyDataSetChanged();
        mAlbumListRv.setVisibility(View.VISIBLE);
        if (mEmptyLayout != null)
            mEmptyLayout.setVisibility(View.GONE);
    }

    @Override
    public void setEmptyLayoutVisible() {
        if (mEmptyLayout != null)
            mEmptyLayout.setVisibility(View.VISIBLE);
        mAlbumListRv.setVisibility(View.GONE);
        mContainerLayout.setVisibility(View.GONE);
        if (mBottomLayout != null)
            mBottomLayout.setVisibility(View.GONE);
    }

    @Override
    public void refreshSelectPictureIndicator() {
        int selectCnt = ImageDataSource.getInstance().size();
        if (selectCnt > 0) {
            //设置可点击
            mSendBtn.setClickable(true);
            mPreviewBtn.setClickable(true);
            mSendBtn.setEnabled(true);
            mPreviewBtn.setEnabled(true);
            //动态设置大小
            ViewGroup.LayoutParams params = mSendBtn.getLayoutParams();
            params.width = ViewGroup.LayoutParams.WRAP_CONTENT;
            mSendBtn.setLayoutParams(params);
            //文字内容和颜色
            mSendBtn.setText(String.format(getStringRes(R.string.im_uikit_picture_send_indicator), selectCnt,
                    ImagePickerConfig.MAX_SELECT_NUM));
            mSendBtn.setTextColor(Color.parseColor("#F3000000"));
            mPreviewBtn.setTextColor(Color.parseColor("#F3000000"));
        } else {
            //动态设置大小，默认长度 46dp
            ViewGroup.LayoutParams params = mSendBtn.getLayoutParams();
            params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46,
                    getContext().getResources().getDisplayMetrics());
            mSendBtn.setLayoutParams(params);
            //文字内容和颜色
            mSendBtn.setText(R.string.im_uikit_send);
            mSendBtn.setTextColor(Color.parseColor("#77000000"));
            mPreviewBtn.setTextColor(Color.parseColor("#77000000"));
            //设置不可点击
            mSendBtn.setEnabled(false);
            mPreviewBtn.setEnabled(false);
            mSendBtn.setClickable(false);
            mPreviewBtn.setClickable(false);
        }
    }

    @Override
    public void setProgressBarVisible(boolean bVisible) {
        mLoadingPBar.setVisibility(bVisible ? View.VISIBLE : View.GONE);
    }

}
