package com.xdja.im.lib.album.ui.view.vu;

import com.xdja.im.base.frame.view.ActivityBaseView;
import com.xdja.im.lib.album.ui.adapter.ImagePreviewAdapter;
import com.xdja.im.lib.album.ui.presenter.ImagePreviewPresenter;

/**
 * @Package: com.xdja.im.lib.album.ui.view.adapterVu
 * @Author: xdjaxa
 * @Creation: 2017-04-25 17:48
 * @Version V1.0
 * @Description:
 */
public interface ImagePreviewVu extends ActivityBaseView<ImagePreviewPresenter> {

    /**
     * 设置适配器
     *
     * @param adapter 适配器
     */
    void setAdapter(ImagePreviewAdapter adapter);

    /**
     * 设置当前选择图片的位置
     *
     * @param position
     */
    void setCurrentPosition(int position);

    /**
     * 刷新title指示器内容
     */
    void refreshTitleIndicator();

    /**
     * 刷新图片选择个数指示器
     */
    void refreshSelectPictureIndicator();

    /**
     * 刷新当前位置的图片信息
     *
     * @param position
     */
    void refreshLocalPictureInfo(int position);

    /**
     * 获取已经被选择的图片数量
     *
     * @return
     */
    int getSelectedCount();

    /**
     * 加载进度是否可见
     */
    void setProgressBarVisible(boolean bVisible);

    /**
     * 提示图片点击进来，直接可以发送，隐藏选中按钮
     */
    void setPromptPicture();
}
