package com.xdja.im.lib.file;

import androidx.annotation.IntDef;

import com.xdja.im.uikit.ImUiKit;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Package: com.xdja.im.lib.file
 * @Author: xdjaxa
 * @Creation: 2017-05-02 9:04
 * @Version V1.0
 * @Description:
 */
public class FileExplorerConfig {

    /**
     * 默认多选文件个数
     */
    public static final int DEFAULT_MULTIPLE_COUNT = 9;

    /**
     * 默认最大可发送文件大小
     */
    public static final long DEFAULT_MAX_SIZE = ImUiKit.getInstance().getComponent().configCache().getDevice().getFileSize() * 1024 * 1024;


    //*****************************************************
    //          文件单选多选定义
    //*****************************************************
    /**
     * 单选
     */
    public static final int MODE_SINGLE = 0X001;
    /**
     * 多选(9张)
     */
    public static final int MODE_MULTIPLE = 0X002;

    @IntDef({MODE_SINGLE, MODE_MULTIPLE})
    @Retention(RetentionPolicy.SOURCE)
    @interface Mode {
    }

    //*****************************************************
    //          图片文件显示形式定义
    //*****************************************************
    /**
     * 图片线性列表显示
     */
    public static final int LINEAR = 0x01;
    /**
     * 图片九宫格显示
     */
    public static final int GRID = 0X02;

    @IntDef({LINEAR, GRID})
    @Retention(RetentionPolicy.SOURCE)
    @interface PHOTOSTYLE {
    }

    /**
     * 最大可选择发送的文件大小
     */
    private long maxSize = DEFAULT_MAX_SIZE;

    @Mode
    private int mode = MODE_MULTIPLE;

    @PHOTOSTYLE
    private int photoStyle = LINEAR;

    public long getMaxSize() {
        return maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public int getMode() {
        return mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getPhotoStyle() {
        return photoStyle;
    }

    public void setPhotoStyle(int photoStyle) {
        this.photoStyle = photoStyle;
    }
}
