package com.xdja.im.lib.file.ui.view;

import android.content.Context;
import android.graphics.Color;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.ViewPager;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.lib.file.ui.presenter.FileExplorerPresenter;
import com.xdja.im.lib.file.ui.view.vu.FileExplorerVu;
import com.xdja.im.lib.file.widget.ViewPagerIndicator;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImActivitySuperView;

/**
 * @Package: com.xdja.im.lib.file.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-24 9:20
 * @Version V1.0
 * @Description:
 */
public class ViewFileExplorer extends ImActivitySuperView<FileExplorerPresenter>
        implements FileExplorerVu {

    private ViewPager viewPager;
    private ViewPagerIndicator indicator;
    private ProgressBar progressBar;
    private TextView mSelectedFileSizeTv;
    private Button mSendBtn;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_file_explorer;
    }

    @Override
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    protected int getToolbarTitle() {
        return R.string.im_uikit_select_file;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        if (view != null) {
            viewPager = (ViewPager) view.findViewById(R.id.file_parent_vp);
            indicator = (ViewPagerIndicator) view.findViewById(R.id.file_parent_indicator);
            mSelectedFileSizeTv = (TextView) view.findViewById(R.id.tv_file_select_size);
            mSendBtn = (Button) view.findViewById(R.id.btn_send);
            progressBar = (ProgressBar) view.findViewById(R.id.pb_loading);
            mSendBtn.setEnabled(false);
        }
    }

    @Override
    public void setAdapter(FragmentPagerAdapter adapter) {
        viewPager.setAdapter(adapter);
        indicator.setViewPager(viewPager);
    }

    @Override
    public void setCurrentSelectedFileSize(Context context, long size) {
        mSelectedFileSizeTv.setText(String.format(context.getString(R.string.im_uikit_file_select_size),
                FileSizeUtils.formatFileSize(size)));
    }

    @Override
    public void setCurrentSelectedFileCount(Context context, int selectCount) {
        if (selectCount == 0) {
            mSendBtn.setText(R.string.im_uikit_send);
            mSendBtn.setClickable(false);
            mSendBtn.setEnabled(false);
            mSendBtn.setTextColor(Color.parseColor("#77000000"));
        } else {
            mSendBtn.setClickable(true);
            mSendBtn.setEnabled(true);
            mSendBtn.setTextColor(Color.parseColor("#F3000000"));
            mSendBtn.setText(String.format(context.getString(R.string.im_uikit_send_indicator), selectCount));
        }
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        progressBar.setVisibility(visibility);
    }
}
