package com.xdja.im.lib.file.ui.view;

import android.view.View;
import android.widget.LinearLayout;

import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.lib.file.bean.FileListType;
import com.xdja.im.lib.file.ui.presenter.FileListFragmentPresenter;
import com.xdja.im.lib.file.ui.view.vu.FileListVu;
import com.xdja.im.lib.file.widget.ViewPagerIndicator;
import com.xdja.im.lib.file.widget.recyclerview.ViewHolder;
import com.xdja.im.uikit.R;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;

public class ViewFileList extends FragmentSuperBaseView<FileListFragmentPresenter>
        implements FileListVu {

    private LinearLayout emptyLayout;
    private RecyclerView recyclerView;
    private LinearLayout localFileLayout;
    private ViewPager viewPager;
    private ViewPagerIndicator indicator;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_file_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        if(view != null){
            emptyLayout = (LinearLayout) view.findViewById(R.id.fragment_file_empty_layout);
            recyclerView = (RecyclerView) view.findViewById(R.id.file_recent_rv);
            localFileLayout = (LinearLayout) view.findViewById(R.id.file_local_tab_layout);
            viewPager = (ViewPager) view.findViewById(R.id.file_child_vp);
            indicator = (ViewPagerIndicator) view.findViewById(R.id.file_child_indicator);
            initView();
        }
    }

    private void initView(){
        showEmptyView(false);
    }

    @Override
    public void showEmptyView(boolean isShow){
        emptyLayout.setVisibility(isShow ? View.VISIBLE : View.GONE);
    }

    @Override
    public RecyclerView getRecyclerView() {
        return recyclerView;
    }

    @Override
    public void setRecyclerViewAdapter(RecyclerView.Adapter<ViewHolder> adapter) {
        recyclerView.setItemAnimator(new DefaultItemAnimator());
        recyclerView.setAdapter(adapter);
    }

    @Override
    public void showViewWithType(int type) {
        recyclerView.setVisibility(type != FileListType.LOCAL.getType() ? View.VISIBLE : View.GONE);
        localFileLayout.setVisibility(type != FileListType.LOCAL.getType() ? View.GONE : View.VISIBLE);
    }

    @Override
    public void setFragmentAdapter(FragmentPagerAdapter adapter) {
        viewPager.setAdapter(adapter);
        indicator.setViewPager(viewPager);
    }

    @Override
    public <A extends Fragment> void setFragment(A fragment) {

    }

}
