package com.xdja.im.lib.file.ui.view.vu;

import android.content.Context;
import androidx.fragment.app.FragmentPagerAdapter;

import com.xdja.im.base.frame.view.ActivityBaseView;
import com.xdja.im.lib.file.ui.presenter.FileExplorerPresenter;

/**
 * @Package: com.xdja.im.lib.file.ui.view.vu
 * @Author: xdjaxa
 * @Creation: 2017-04-24 9:20
 * @Version V1.0
 * @Description:
 */
public interface FileExplorerVu extends ActivityBaseView<FileExplorerPresenter> {

    void setAdapter(FragmentPagerAdapter adapter);

    /**
     * 设置当前已选文件大小
     * @param size 文件大小
     */
    void setCurrentSelectedFileSize(Context context, long size);

    /**
     * 设置当前已选文件个数
     *
     * @param selectCount
     */
    void setCurrentSelectedFileCount(Context context, int selectCount);

    /**
     * 加载进度是否可见设置
     *
     * @param visibility
     */
    void setProgressBarVisibility(int visibility);
}
