package com.xdja.im.lib.filemanage.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;

import com.xdja.im.lib.filemanage.commend.Command;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.List;

import androidx.recyclerview.widget.RecyclerView;

public abstract class BaseRecyclerViewAdapter<P extends Command,D> extends RecyclerView.Adapter<BaseRecyclerViewAdapter.CustomViewHolder>
    implements View.OnClickListener, View.OnLongClickListener{

    private LayoutInflater inflater;
    @Override
    public BaseRecyclerViewAdapter.CustomViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        AdapterVu<P,D> adapterVu = null;
        View convertView = null;
        if (inflater == null) {
            inflater = (LayoutInflater) parent.getContext()
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        }

        try {
            Class<? extends AdapterVu<P,D>> viewClazz = getVuClassByViewType(viewType);
            if(viewClazz != null){
                adapterVu = viewClazz.newInstance();
                adapterVu.setCommand(getCommand());
                adapterVu.setActivity(getActivity());

                adapterVu.init(inflater, parent);
                convertView = adapterVu.getView();
                convertView.setOnClickListener(this);
                convertView.setOnLongClickListener(this);
                convertView.setTag(adapterVu);
                adapterVu.onViewCreated();
            }
        }catch (IllegalAccessException ex) {
            LogUtil.e("", ex.getMessage());
        } catch (InstantiationException ex) {
            LogUtil.e("", ex.getMessage());
        }

        return new BaseRecyclerViewAdapter.CustomViewHolder(convertView);
    }

    @Override
    public void onBindViewHolder(BaseRecyclerViewAdapter.CustomViewHolder holder, int position) {
        if(holder != null){
            AdapterVu<P,D> adapterVu = (AdapterVu<P, D>) holder.itemView.getTag();
            adapterVu.bindDataSource(position, getDataSource(position));
        }
    }

    public abstract D getDataSource(int position);

    public abstract P getCommand();

    protected abstract List<Class<? extends AdapterVu<P,D>>> getVuClasses();

    protected abstract Class<? extends AdapterVu<P,D>> getVuClassByViewType(int itemViewType) ;

    protected Activity getActivity(){
        return null;
    }

    protected ListView getListView(){
        return null;
    }

    /**
     * 叶子节点点击事件
     * @param position
     */
    protected abstract void clickChildLeaf(View view, int position);
    /**
     * 折叠或者打开方法,第几个位置position
     * @param position
     */
    protected abstract void collapseOrExpand(int position);

    public class CustomViewHolder extends RecyclerView.ViewHolder{

        public CustomViewHolder(View itemView) {
            super(itemView);
        }
    }
}
