package com.xdja.im.lib.filemanage.adapter;

import android.app.Activity;
import android.view.View;
import android.widget.CheckBox;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.commend.ILastPhotoAndVideoAdapterCommand;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.NodeUtils;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.lib.filemanage.view.ViewLastGridTitleItem;
import com.xdja.im.lib.filemanage.view.ViewLastPhotoItem;
import com.xdja.im.lib.filemanage.view.ViewLastVideoItem;
import com.xdja.im.uikit.R;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class LastPhotoAndVideoAdapter extends BaseRecyclerViewAdapter<ILastPhotoAndVideoAdapterCommand, GridItemBean>
        implements ILastPhotoAndVideoAdapterCommand {

    private static final int PARENT_DIR = 0;
    private static final int CHILD_LEAF = 1;
    private static final int CHILD_LEAF_VIDEO = 2;

    private static final int MIN_CLICK_DELAY_TIME = 500;
    private BusProvider busProvider;

    private Map<HistoryFileCategory, List<TalkMessageBean>> dataMaps;
    private List<GridItemBean> dataSources;
    private Activity activity;

    private long lastClickTime = 0;
    private CommonSpanSizeLookup spanSizeLookup;

    private RecyclerView recyclerView;

    private List<Class<? extends AdapterVu<ILastPhotoAndVideoAdapterCommand, GridItemBean>>> vuClasses;

    public LastPhotoAndVideoAdapter(BusProvider busProvider, Map<HistoryFileCategory, List<TalkMessageBean>> datas) {
        this.busProvider = busProvider;
        dataMaps = datas;
        dataSources = NodeUtils.convertData(datas);
    }

    public void setDataSources(Map<HistoryFileCategory, List<TalkMessageBean>> datas){
        dataMaps = datas;
        dataSources = NodeUtils.convertData(datas);
    }
    @Override
    public GridItemBean getDataSource(int position) {
        return dataSources != null && dataSources.size() > 0 ? dataSources.get(position) : null;
    }

    @Override
    public ILastPhotoAndVideoAdapterCommand getCommand() {
        return this;
    }

    @Override
    protected List<Class<? extends AdapterVu<ILastPhotoAndVideoAdapterCommand, GridItemBean>>> getVuClasses() {
        if (vuClasses == null) {
            vuClasses = new ArrayList<>();
            vuClasses.add(ViewLastGridTitleItem.class);
            vuClasses.add(ViewLastPhotoItem.class);
            vuClasses.add(ViewLastVideoItem.class);
        }
        return vuClasses;
    }

    @Override
    public int getItemViewType(int position) {

        if (dataSources.get(position).isLeaf()) {
            TalkMessageBean dataTalk = (TalkMessageBean) dataSources.get(position).getValue();
            FileInfo fileInfo = dataTalk.getFileInfo();
            if (fileInfo.getFileType() == ConstDef.FILE_TYPE_VIDEO) {
                return CHILD_LEAF_VIDEO;
            } else if (fileInfo.getFileType() == ConstDef.FILE_TYPE_PHOTO) {
                return CHILD_LEAF;
            }
        }
        return PARENT_DIR;
    }

    @Override
    protected void clickChildLeaf(View view, int position) {
        CheckBox checkBox = null;
        switch (getItemViewType(position)){
            case CHILD_LEAF:
                checkBox = (CheckBox)view.findViewById(R.id.chx_img_file_select);
                break;
            case CHILD_LEAF_VIDEO:
                checkBox = (CheckBox)view.findViewById(R.id.chx_video_file_select);
                break;
            default:
                break;
        }
        if(checkBox != null){
            if(FileInfoCollection.getInstance().getSelectedFileCount() >= 9 && !checkBox.isChecked()){
                new XToast(activity).display(String.format(activity.getString(R.string.im_uikit_select_file_hint), 9));
                return;
            }
            checkBox.setChecked(!checkBox.isChecked());
        }
    }

    @Override
    protected void collapseOrExpand(int position) {
        GridItemBean bean = dataSources.get(position);
        HistoryFileCategory title = (HistoryFileCategory) bean.getValue();
        List<TalkMessageBean> childLists = bean.getChildList();

        List<TalkMessageBean> originChilds = dataMaps.get(title);
        if (bean.isExpand()) {
            //折叠
            for (TalkMessageBean fInfo : childLists) {
                GridItemBean<TalkMessageBean> deleteBean = new GridItemBean();
                deleteBean.setValue(fInfo);
                dataSources.remove(deleteBean);
            }
            bean.setExpand(!bean.isExpand());
            notifyItemRangeRemoved(position + 1, childLists.size());
        } else {
            //显示
            List<GridItemBean> addChildItem = new ArrayList<>();
            for (TalkMessageBean fInfo : originChilds) {
                GridItemBean<TalkMessageBean> addBean = new GridItemBean();
                addBean.setValue(fInfo);
                addBean.setChildList(null);
                addChildItem.add(addBean);
            }
            dataSources.addAll(position + 1, addChildItem);
            bean.setExpand(!bean.isExpand());
            notifyItemRangeInserted(position + 1, addChildItem.size());
        }
        notifyItemChanged(position);
    }

    @Override
    public int getItemCount() {
        return dataSources != null ? dataSources.size() : 0;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Override
    public Activity getActivity() {
        return activity;
    }

    @Override
    public void onClick(View v) {
        int position = recyclerView.getChildAdapterPosition(v);
        if(position < 0 || position >= dataSources.size()){
            return;
        }
        switch (getItemViewType(position)) {
            case PARENT_DIR:
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastClickTime > MIN_CLICK_DELAY_TIME) {
                    lastClickTime = currentTime;
                    collapseOrExpand(position);
                }
                break;
            case CHILD_LEAF:
            case CHILD_LEAF_VIDEO:
                clickChildLeaf(v, position);
                break;
            default:
                break;
        }
    }

    @Override
    public boolean onLongClick(View v) {
        return false;
    }

    private CommonSpanSizeLookup getSpanSizeLookup() {
        if (spanSizeLookup == null) {
            spanSizeLookup = new CommonSpanSizeLookup();
        }
        return spanSizeLookup;
    }

    public void setLayoutManager(int col) {
        GridLayoutManager layoutManager = new GridLayoutManager(activity, col);
        layoutManager.setSpanSizeLookup(getSpanSizeLookup());
        recyclerView.setLayoutManager(layoutManager);
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    @Override
    protected Class<? extends AdapterVu<ILastPhotoAndVideoAdapterCommand, GridItemBean>> getVuClassByViewType(int itemViewType) {
        Class<? extends AdapterVu<ILastPhotoAndVideoAdapterCommand, GridItemBean>> clazz = null;
        switch (itemViewType) {
            case CHILD_LEAF:
                clazz = getVuClasses().get(1);
                break;
            case PARENT_DIR:
                clazz = getVuClasses().get(0);
                break;
            case CHILD_LEAF_VIDEO:
                clazz = getVuClasses().get(2);
                break;
        }
        return clazz;
    }

    @Override
    public void toRefreshSelectHint(FileItem localFileInfo) {

        IMProxyEvent.FileSelectedEvent event = new IMProxyEvent.FileSelectedEvent(localFileInfo);
        busProvider.post(event);
    }

    private class CommonSpanSizeLookup extends GridLayoutManager.SpanSizeLookup {

        @Override
        public int getSpanSize(int position) {
            int viewType = getItemViewType(position);
            if (viewType == PARENT_DIR) {
                return 4;
            }
            return 1;
        }
    }
}
