package com.xdja.im.lib.filemanage.util;

import android.text.TextUtils;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.ThumbnailUtils;
import com.xdja.imsdk.util.ToolUtils;

import java.io.File;
import java.util.UUID;

import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func3;
import rx.schedulers.Schedulers;

/**
 * 数据实体类
 * Created by xdjaxa on 2016/8/8.
 */
public class ModelGenerator {

    /**
     * 根据本地图片信息，生成图片文件相关信息
     *
     * @param pictureInfo 本地图片信息
     * @param account     用户账号
     * @return 图片文件信息实体类
     */
    public static Observable<FileInfo> createImageFileInfo(final ImageFileInfo pictureInfo,
                                                           final String account) {
        if (pictureInfo == null || TextUtils.isEmpty(account)) {
            return null;
        }

        if (ConstDef.GIF_TYPE.equalsIgnoreCase(pictureInfo.getSuffix())) {
            return createGifImageFileInfo(pictureInfo, account, false);
        } else {
            //juyingang fix bug 4236 begin
            String imageFilePath = pictureInfo.getFilePath();

            try {
                File file = new File(imageFilePath);
                if (!file.exists()) {
                    return Observable.error(new Throwable(ActomaController.getAppConfigContext().getString(R.string.im_uikit_file_not_exist)));
                }
            } catch (Exception e) {
                LogUtil.e("", e);// add by ycm for lint 2017/02/16
            }
            //juyingang fix bug 4236 begin

            //缩略图文件保存父路径
            String imageRootPath = getRootFilePath(account);
            //文件名称
            final String baseFileName = UUID.randomUUID().toString();
            final String thumbName = ImSdkFileConstant.THUMBNAIL_FILE_PREFIX + baseFileName;
            final String hdThumbName = ImSdkFileConstant.THUMBNAIL_FILE_PREFIX + baseFileName + "_hd";

            return Observable.zip(
                    //高清缩略图
                    createHDThumbnail(pictureInfo.getFilePath(), new File(imageRootPath, hdThumbName)),
                    //缩略图
                    createThumbnail(pictureInfo.getFilePath(), new File(imageRootPath, thumbName)),
                    //原图
                    createRawFilePath(pictureInfo.getFilePath(), new File(imageRootPath, baseFileName), true),
                    //生成实体类
                    new Func3<String, String, String, FileInfo>() {

                        @Override
                        public ImageFileInfo call(String hdThumbFilePath,
                                                  String thumbFilePath,
                                                  String rawFilePath) {
                            return pictureInfo;
                        }
                    }
            );
        }
    }

    public static Observable<FileInfo> createPictureFileInfo(final ImageFileInfo pictureInfo,
                                                             final String account) {
        if (pictureInfo == null || TextUtils.isEmpty(account)) {
            return null;
        }

        if (ConstDef.GIF_TYPE.equalsIgnoreCase(pictureInfo.getSuffix())) {
            return createGifImageFileInfo(pictureInfo, account, true);
        } else {
            //juyingang fix bug 4236 begin
            String imageFilePath = pictureInfo.getFilePath();

            try {
                File file = new File(imageFilePath);
                if (!file.exists()) {
                    return Observable.error(new Throwable(ActomaController.getAppConfigContext().getString(R.string.im_uikit_file_not_exist)));
                }
            } catch (Exception e) {
                LogUtil.e("", e);// add by ycm for lint 2017/02/16
            }
            //juyingang fix bug 4236 begin

            //缩略图文件保存父路径
            String imageRootPath = getRootFilePath(account);
            //文件名称
            final String baseFileName = UUID.randomUUID().toString();
            final String thumbName = ImSdkFileConstant.THUMBNAIL_FILE_PREFIX + baseFileName;
            final String hdThumbName = ImSdkFileConstant.THUMBNAIL_FILE_PREFIX + baseFileName + "_hd";

            return Observable.zip(
                    //高清缩略图
                    createHDThumbnail(pictureInfo.getFilePath(), new File(imageRootPath, hdThumbName)),
                    //缩略图
                    createThumbnail(pictureInfo.getFilePath(), new File(imageRootPath, thumbName)),
                    //原图
                    createRawFilePath(pictureInfo.getFilePath(), new File(imageRootPath, baseFileName), true),
                    //生成实体类
                    new Func3<String, String, String, FileInfo>() {

                        @Override
                        public ImageFileInfo call(String hdThumbFilePath,
                                                  String thumbFilePath,
                                                  String rawFilePath) {
                            if (TextUtils.isEmpty(hdThumbFilePath) ||
                                    TextUtils.isEmpty(thumbFilePath) ||
                                    TextUtils.isEmpty(rawFilePath)) {
                                return null;
                            }

                            ImageFileInfo imageFileInfo = new ImageFileInfo();
                            //缩略图信息
                            imageFileInfo.setFileName(thumbName);
                            imageFileInfo.setFilePath(thumbFilePath);
                            imageFileInfo.setFileSize(ToolUtil.getFileSize(thumbFilePath));
                            imageFileInfo.setTranslateSize(0);
                            String suffix = ToolUtil.getLastString(rawFilePath, ".");
                            if(!ToolUtils.isImageSuffix(suffix)){
                                suffix = ImSdkFileConstant.THUMBNAIL_FILE_SUFFIX.substring(1);
                            }
                            imageFileInfo.setSuffix(suffix);

                            //高清缩略图信息
                            FileInfo fileExtraInfo = new FileInfo();
                            fileExtraInfo.setFileName(hdThumbName);
                            fileExtraInfo.setFilePath(hdThumbFilePath);
                            fileExtraInfo.setFileSize(ToolUtil.getFileSize(hdThumbFilePath));

                            //原图信息
                            FileInfo rawExtraInfo = new FileInfo();
                            rawExtraInfo.setFileName(baseFileName);
                            rawExtraInfo.setFilePath(rawFilePath);
                            rawExtraInfo.setFileSize(pictureInfo.getFileSize());

                            //是否需要发送原图
                            imageFileInfo.setOriginal(true);
                            //数据填充
                            imageFileInfo.setFileType(ConstDef.FILE_TYPE_PHOTO);
                            imageFileInfo.setHdFileInfo(fileExtraInfo);
                            imageFileInfo.setRawFileInfo(rawExtraInfo);


//                            FileInfo imageFileInfo = new FileInfo();
//                            //缩略图信息
//                            imageFileInfo.setFileName(thumbName);
//                            imageFileInfo.setFilePath(thumbFilePath);
//                            imageFileInfo.setFileSize(ToolUtil.getFileSize(thumbFilePath));
//                            imageFileInfo.setTranslateSize(0);
//                            String suffix = ToolUtil.getLastString(rawFilePath, ".");
//                            if (!ToolUtils.isImageSuffix(suffix)) {
//                                suffix = ImSdkFileConstant.THUMBNAIL_FILE_SUFFIX.substring(1);
//                            }
//                            imageFileInfo.setSuffix(suffix);
//                            pictureInfo.setGifFileInfo(imageFileInfo);
//                            FileInfo fileExtraInfo = new FileInfo();
//                            //高清缩略图信息
//                            fileExtraInfo.setFileName(hdThumbName);
//                            fileExtraInfo.setFilePath(hdThumbFilePath);
//                            fileExtraInfo.setFileSize(ToolUtil.getFileSize(hdThumbFilePath));
//                            pictureInfo.setHdFileInfo(fileExtraInfo);
//
//                            FileInfo fileRawExtraInfo = new FileInfo();
//                            //原图信息
//                            fileRawExtraInfo.setFileName(baseFileName);
//                            fileRawExtraInfo.setFilePath(rawFilePath);
//                            if (true) {
//                                fileRawExtraInfo.setFileSize(pictureInfo.getFileSize());
//                            } else {
//                                fileRawExtraInfo.setFileSize(0);
//                            }
//                            //是否需要发送原图
//                            pictureInfo.setOriginal(true);
//                            pictureInfo.setRawFileInfo(fileRawExtraInfo);

                            return imageFileInfo;
                        }
                    }
            );
        }
    }

    /**
     * 高清缩略图处理
     *
     * @param originalPath
     * @param thumbFile
     * @return
     */
    public static Observable<String> createHDThumbnail(final String originalPath,
                                                       final File thumbFile) {

        return Observable.just(originalPath)
                .subscribeOn(Schedulers.newThread())
                .map(new Func1<String, String>() {
                    @Override
                    public String call(String path) {
                        return ThumbnailUtils.createImageThumbnail(path,
                                ThumbnailUtils.KIND_HD, thumbFile);
                    }
                });
        /*return Observable.just(originalPath)
                .subscribeOn(Schedulers.computation())
                .map(new Func1<String, Bitmap>() {
                    @Override
                    public Bitmap call(String s) {
                        return ThumbUtils.getHDThumbFilePath(originalPath);
                    }
                })
                .subscribeOn(Schedulers.io())
                .map(new Func1<Bitmap, String>() {
                    @Override
                    public String call(Bitmap bitmap) {
                        if (bitmap != null) {
                            return ThumbUtils.saveBitmap(bitmap, 75, thumbFile);
                        } else {
                            return ThumbUtils.copyFile(originalPath, thumbFile);
                        }
                    }
                });*/
    }

    /**
     * 缩略图处理
     *
     * @param originalPath
     * @param thumbFile
     */
    public static Observable<String> createThumbnail(final String originalPath,
                                                     final File thumbFile) {
        return Observable.just(originalPath)
                .subscribeOn(Schedulers.newThread())
                .map(new Func1<String, String>() {
                    @Override
                    public String call(String path) {
                        return ThumbnailUtils.createImageThumbnail(path,
                                ThumbnailUtils.KIND_TH, thumbFile);
                    }
                });
        /*return Observable.just(originalPath)
                .subscribeOn(Schedulers.computation())
                .map(new Func1<String, Bitmap>() {
                    @Override
                    public Bitmap call(String s) {
                        //生成缩略图
                        return ThumbUtils.getThumbFilePath(originalPath);
                    }
                })
                .subscribeOn(Schedulers.io())
                .map(new Func1<Bitmap, String>() {
                    @Override
                    public String call(Bitmap bitmap) {
                        if (bitmap != null){
                            return ThumbUtils.saveBitmap(bitmap, 75, thumbFile);
                        } else {
                            return ThumbUtils.copyFile(originalPath, thumbFile);
                        }
                    }
                });*/
    }


    /**
     * 原图处理
     *
     * @param originalPath
     * @param filePath
     * @param isOriginalPic
     * @return
     */
    public static Observable<String> createRawFilePath(final String originalPath,
                                                       final File filePath,
                                                       final boolean isOriginalPic) {

        return Observable.just(originalPath)
                .subscribeOn(Schedulers.io())
                .map(new Func1<String, String>() {
                    @Override
                    public String call(String originalPath) {
                        //将原图拷贝至缓存目录下
                        //if (isOriginalPic) {
                        //    return ThumbUtils.copyFile(originalPath, filePath);
                        //} else {
                        return originalPath;
                        //}
                    }
                });
    }

    /**
     * 根据本地动态图片信息，生成图片文件相关信息
     *
     * @param pictureInfo 本地图片信息
     * @param account     用户账号
     * @return 图片文件信息实体类
     */
    public static Observable<FileInfo> createGifImageFileInfo(final ImageFileInfo pictureInfo,
                                                              final String account,
                                                              final boolean isFile) {
        if (pictureInfo == null || TextUtils.isEmpty(account)) {
            return null;
        }

        String imageFilePath = pictureInfo.getFilePath();

        try {
            File file = new File(imageFilePath);
            if (!file.exists()) {
                return Observable.error(new Throwable(ActomaController.getAppConfigContext().getString(R.string.im_uikit_file_not_exist)));
            }
        } catch (Exception e) {
            LogUtil.e("", e);
        }

        //缩略图文件保存父路径
        String imageRootPath = getRootFilePath(account);
        //文件名称
        final String baseFileName = UUID.randomUUID().toString();
        final String thumbName = ImSdkFileConstant.THUMBNAIL_FILE_PREFIX + baseFileName;

        return Observable.zip(
                //高清缩略图
                createRawFilePath(pictureInfo.getFilePath(), new File(imageRootPath, baseFileName), false),
                //缩略图
                createGifFirstFrameFilePath(pictureInfo.getFilePath(), new File(imageRootPath, thumbName)),
                //原图
                createRawFilePath(pictureInfo.getFilePath(), new File(imageRootPath, baseFileName), true),
                //生成实体类
                new Func3<String, String, String, FileInfo>() {

                    @Override
                    public ImageFileInfo call(String hdThumbFilePath,
                                              String thumbFilePath,
                                              String rawFilePath) {
                        return pictureInfo;
                    }
                }
        );
    }

    /**
     * gif原图处理
     *
     * @param originalPath
     * @param thumbFile
     * @return
     */
    public static Observable<String> createGifFirstFrameFilePath(final String originalPath,
                                                                 final File thumbFile) {

        return Observable.just(originalPath)
                .subscribeOn(Schedulers.io())
                .map(new Func1<String, String>() {
                    @Override
                    public String call(String originalPath) {
                        return null;
                    }
                });
    }

    /**
     * 获取文件保存父路径
     *
     * @return
     */
    public static String getRootFilePath(String account) {
        //创建父目录
        File imageCacheFile = new File(FileUtils.getImagePath());
        if (!imageCacheFile.isDirectory()) {
            imageCacheFile.deleteOnExit();
        }

        if (!imageCacheFile.exists()) {
            if (imageCacheFile.mkdirs()) {
                return imageCacheFile.getAbsolutePath();
            }

        } else {
            return imageCacheFile.getAbsolutePath();
        }

        return FileUtils.getImagePath();
//        if (!imageCacheFile.exists()) {
//            imageCacheFile.mkdirs();
//        }
//        File imageRootPath = new File(imageCacheFile, account);
//        if (!imageRootPath.exists()){
//            if (!imageRootPath.mkdirs()){
//                LogUtil.w("create image root file path failed.");
//            }
//        }
//        return imageRootPath.getAbsolutePath();
    }

    public static ImageFileInfo createContentImageFile(String path, String account) {
        if (path == null || TextUtils.isEmpty(account)) {
            return null;
        }
        try {
            //缩略图文件保存父路径
            String imageRootPath = getRootFilePath(account);
            //文件名称
            final String baseFileName = UUID.randomUUID().toString();
            final String thumbName = ImSdkFileConstant.THUMBNAIL_FILE_PREFIX + baseFileName;
            final String hdThumbName = ImSdkFileConstant.THUMBNAIL_FILE_PREFIX + baseFileName + "_hd";
            String hdThumbFilePath =  ThumbnailUtils.createImageThumbnail(path,
                    ThumbnailUtils.KIND_HD, new File(imageRootPath, hdThumbName));
            String thumbFilePath = ThumbnailUtils.createImageThumbnail(path,
                    ThumbnailUtils.KIND_TH, new File(imageRootPath, thumbName));
           // String rawFilePath = path;
            ImageFileInfo imageFileInfo = new ImageFileInfo();
            //缩略图信息
            imageFileInfo.setFileName(thumbName);
            imageFileInfo.setFilePath(thumbFilePath);
            imageFileInfo.setFileSize(ToolUtil.getFileSize(thumbFilePath));
            imageFileInfo.setTranslateSize(0);
            String suffix = ToolUtil.getLastString(path, ".");
            if(!ToolUtils.isImageSuffix(suffix)){
                suffix = ImSdkFileConstant.THUMBNAIL_FILE_SUFFIX.substring(1);
            }
            imageFileInfo.setSuffix(suffix);

            //高清缩略图信息
            FileInfo fileExtraInfo = new FileInfo();
            fileExtraInfo.setFileName(hdThumbName);
            fileExtraInfo.setFilePath(hdThumbFilePath);
            fileExtraInfo.setFileSize(ToolUtil.getFileSize(hdThumbFilePath));

            //原图信息
            FileInfo rawExtraInfo = new FileInfo();
            rawExtraInfo.setFileName(baseFileName);
            /*rawExtraInfo.setFilePath();
            rawExtraInfo.setFileSize(ToolUtil.getFileSize(rawFilePath));
*/
            //是否需要发送原图
            imageFileInfo.setOriginal(false);
            imageFileInfo.setHdFileInfo(fileExtraInfo);
            return imageFileInfo;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
