package com.xdja.im.lib.filemanage.view;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.lib.filemanage.commend.ILastFileListCommand;
import com.xdja.im.lib.filemanage.commend.ILastFileListVu;
import com.xdja.im.uikit.R;

import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;


/**
 * <p>Author: leiliangliang         </br>
 * <p>Date: 2016/12/2 16:57   </br>
 * <p>Package: com.xdja.imp.ui</br>
 * <p>Description:聊天文件列表fragment </br>
 */
public class ViewLastFileList extends FragmentSuperView<ILastFileListCommand> implements
        ILastFileListVu<ILastFileListCommand>, ViewPager.OnPageChangeListener, View.OnClickListener{

    private TextView[] mTabTvs;
    private ViewPager mViewPager;

    private SharedPreferences sharedPreferences;

    /**
     * tab指示标签
     */
    private ImageView mCursorImg;
    /**
     * 指示标签宽度
     */
    private int mCursorW = 0;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_last_file;
    }

    @Override
    protected void injectView() {
        super.injectView();

        if (getView() != null) {


            TextView mTableVideoPhotos = (TextView) getView().findViewById(R.id.tv_last_video_image);
            TextView mTableDoc = (TextView) getView().findViewById(R.id.tv_last_document);
            TextView mTableOther = (TextView) getView().findViewById(R.id.tv_last_other);

            mViewPager = (ViewPager) getView().findViewById(R.id.pager_last_files);
            mCursorImg = (ImageView) getView().findViewById(R.id.img_cursor);


            mTabTvs = new TextView[]{
                    mTableVideoPhotos,
                    mTableDoc,
                    mTableOther
            };
            mTabTvs[0].setTextColor(getColorRes(R.color.im_uikit_base_black_95));

            //设置tab指示器大小
            DisplayMetrics dm = new DisplayMetrics();
            getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
            int screenW = dm.widthPixels;
            mCursorW = screenW / mTabTvs.length;

            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mCursorImg.getLayoutParams();
            params.width = mCursorW;
            mCursorImg.setLayoutParams(params);

            //tab点击事件监听器
            for (TextView mTabTv : mTabTvs) {
                mTabTv.setOnClickListener(this);
            }
            mViewPager.addOnPageChangeListener(this);
        }
        sharedPreferences = getActivity().getSharedPreferences(ConstDef.PAGE_TAB_POSITION_RECORD, Context.MODE_PRIVATE);
    }

    @Override
    public void onDestroyView() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(ConstDef.LAST_FILE_PAGE_POSITION, mViewPager.getCurrentItem());
        editor.apply();

        super.onDestroyView();
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

    }

    @Override
    public void onPageSelected(int position) {
        for(TextView mTabTv : mTabTvs) {
            mTabTv.setTextColor(getColorRes(R.color.im_uikit_base_black_37));
        }
        mTabTvs[position].setTextColor(getColorRes(R.color.im_uikit_base_black_95));
        mCursorImg.setX(mCursorW * position);
    }

    @Override
    public void onPageScrollStateChanged(int state) {

    }

    @Override
    public void onClick(View v) {
        int index;
        for(index=0; index < mTabTvs.length; index++){
            if(mTabTvs[index].getId() == v.getId()){
                break;
            }
        }
        mViewPager.setCurrentItem(index, false);
    }

    @Override
    public void setFragmentAdapter(PagerAdapter adapter) {
        mViewPager.setOffscreenPageLimit(adapter.getCount());
        mViewPager.setAdapter(adapter);
        mViewPager.setCurrentItem(sharedPreferences.getInt(ConstDef.LAST_FILE_PAGE_POSITION, 0));
    }
}
