package com.xdja.im.lib.filemanage.view;

import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.presenter.BasePresenterActivity;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.uikit.R;

public class ViewLastPhotoItem extends ViewLastBaseItem {

    private ImageView imageView;

    private CheckBox isSelected;

    private int style;
    private SharedPreferences sp;
    private SharedPreferences.Editor edit;
    private static String PHOTO_ITEM_SELECT_SP = "view_last_photo_item";

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_file_image_fragment_image;
    }
    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        style = UniversalUtil.getThemeStyle(getContext());
        if (view != null) {
            imageView = (ImageView) view.findViewById(R.id.image_file_image);
            isSelected = (CheckBox) view.findViewById(R.id.chx_img_file_select);
        }
        sp = getActivity().getSharedPreferences(PHOTO_ITEM_SELECT_SP, 0);
        edit = sp.edit();
    }

    @Override
    public void bindDataSource(int position, @NonNull final GridItemBean dataSource) {
        super.bindDataSource(position, dataSource);
        final TalkMessageBean dataTalk = (TalkMessageBean) dataSource.getValue();
        final FileInfo fileInfo = dataTalk.getFileInfo();

        isSelected.setVisibility(View.VISIBLE);
        isSelected.setChecked(dataTalk.isChecked());
        isSelected.setClickable(false);

        isSelected.setButtonDrawable(dataTalk.isChecked() ? (style ==
                BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) :
                R.drawable.im_uikit_icon_selected_off);

        isSelected.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(sp == null) {
                    return;
                }
                boolean isCurSelected = sp.getBoolean(String.valueOf(dataTalk.getId()), false);
                isCurSelected = !isCurSelected;
                dataTalk.setChecked(isCurSelected);
                edit.putBoolean(String.valueOf(dataTalk.getId()), isCurSelected);
                edit.commit();
                isSelected.setButtonDrawable(isCurSelected ? (style ==
                        BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) :
                        R.drawable.im_uikit_icon_selected_off);

                String fileName = fileInfo.getFileName();
                if (TextUtils.isEmpty(ToolUtil.getLastString(fileName, "."))) {
                    fileName = fileName + "." + fileInfo.getSuffix();
                }

                String filePath = fileInfo.getFilePath();
                long fileSize = fileInfo.getFileSize();
                FileItem localFileInfo = new FileItem(fileName, filePath, fileSize, 0, fileInfo.getFileType());

                if (isCurSelected) {
                    FileInfoCollection.getInstance().putFileToSelectedCache(filePath + dataTalk.getId(), localFileInfo);
                } else {
                    FileInfoCollection.getInstance().removeToSelectedCache(filePath + dataTalk.getId());
                }
                getCommand().toRefreshSelectHint(localFileInfo);
            }
        });

        Glide.with(getActivity())
                .load(fileInfo.getFilePath())
                .error(R.drawable.im_uikit_ic_jpg)
                .centerCrop()
                .override(240, 240)
                .into(imageView);
    }
}