package com.xdja.im.lib.filemanage.view;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.xdja.im.lib.filemanage.commend.IPhotoAndVideoCommand;
import com.xdja.im.uikit.R;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


public class ViewPhotoAndVideo extends FragmentSuperView<IPhotoAndVideoCommand>
    implements IPhotoAndVideoFragmentVu{

    private RecyclerView mRecyclerView;
    private LinearLayout mEmptyLayout;
    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_file_fragment_image_layout;
    }

    @Override
    protected void injectView() {
        super.injectView();

        View view = getView();
        if(view != null){
            mEmptyLayout = (LinearLayout) view.findViewById(R.id.history_file_image_empty_layout);
            mRecyclerView = (RecyclerView) view.findViewById(R.id.rl_content);
        }
    }

    @Override
    public void init(@NonNull LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
    }


    @Override
    public RecyclerView getRecyclerView() {
        return mRecyclerView;
    }

    @Override
    public void setRecyclerViewAdapter(RecyclerView.Adapter adapter) {
        mRecyclerView.setItemAnimator(new DefaultItemAnimator());
        mRecyclerView.setAdapter(adapter);
    }

    @Override
    public void setLayoutManager(GridLayoutManager manager) {
        mRecyclerView.setLayoutManager(manager);
    }

    @Override
    public void showEmpty(boolean isShowEmpty) {
        mEmptyLayout.setVisibility(isShowEmpty ? View.VISIBLE : View.GONE);
    }


}
