package com.xdja.im.lib.historyfile.fragment;

import android.os.Bundle;
import androidx.annotation.NonNull;

import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.filemanage.commend.IPhotoAndVideoCommand;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.presenter.IMFragmentPresenter;
import com.xdja.im.lib.filemanage.view.IPhotoAndVideoFragmentVu;
import com.xdja.im.lib.filemanage.view.ViewPhotoAndVideo;
import com.xdja.im.lib.historyfile.adapter.HistoryPhotoAndVideoAdapter;
import com.xdja.im.lib.historyfile.util.DataSourceFilter;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.ArrayList;
import java.util.List;


public class HistoryPhotoAndVideoFragment extends IMFragmentPresenter<IPhotoAndVideoCommand, IPhotoAndVideoFragmentVu>
        implements IPhotoAndVideoCommand {

    private String flag;

    BusProvider busProvider;

    private HistoryPhotoAndVideoAdapter adapter;

    private List<GridItemBean> dataSource;

    public void setDatas(List<GridItemBean> dataSource){
        this.dataSource = dataSource;
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == useCaseComponent) {
            LogUtil.e("HistoryPhotoAndVideoFragment", "useCaseComponent is null");
            return;
        }
        useCaseComponent.inject(this);
        busProvider = BusProvider.getInstance();
        busProvider.register(this);

        Bundle bundle = getArguments();
        if (bundle != null) {
            flag = bundle.getString(ConstDef.TAG_TALKFLAG);
        }
        adapter = new HistoryPhotoAndVideoAdapter(flag, busProvider, dataSource);
        useCaseComponent.inject(adapter);
        adapter.setActivity(getActivity());
        adapter.setRecyclerView(getVu().getRecyclerView());
        adapter.setLayoutManager(4);
        getVu().setRecyclerViewAdapter(adapter);
        //((HistoryFileActivityPresenter) getActivity()).obtainDataMap();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();

        if(busProvider != null){
            busProvider.unregister(this);
        }
    }

    public void notifyDataChange(){
        getVu().showEmpty(dataSource.size() == 0);
        adapter.notifyDataSetChanged();
    }

    public void updateUIAfterDeleteFiles(List<TalkMessageBean> deleteBeans) {
        for (TalkMessageBean bean : deleteBeans) {
            adapter.randomRemoveLeafItem(bean.getId());
        }
        getVu().showEmpty(dataSource.size() == 0);
    }

    @Subscribe
    public void receiveFilePaused(final IMProxyFileEvent.ReceiveFilePausedEvent event){
        TalkMessageBean bean = DataSourceFilter.getTalkMessageBeanWithId(dataSource, event.getAttachedMsgId());
        FileInfo fileInfo = event.getFileInfo();
        LogUtil.d("","HistoryFile paused:" + fileInfo.getTranslatePercent());
        if(bean != null){
            bean.getFileInfo().setFileState(ConstDef.PAUSE);
            adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void receiveFileFinishedEvent(final IMProxyFileEvent.ReceiveFileFinishedEvent event){
        TalkMessageBean bean = DataSourceFilter.getTalkMessageBeanWithId(dataSource, event.getAttachedMsgId());
        if(bean != null && event.getFileInfo() != null){
            FileInfo fileInfo = bean.getFileInfo();
            fileInfo.setFileState(ConstDef.DONE);
            if (fileInfo instanceof VideoFileInfo) {
                ((VideoFileInfo) fileInfo).getRawFileInfo().setFileState(ConstDef.DONE);
            } else if (fileInfo instanceof ImageFileInfo){
                int type = ((ImageFileInfo) event.getFileInfo()).getType();
                if (type == ConstDef.IS_RAW) {
                    ((ImageFileInfo) fileInfo).getRawFileInfo().setFileState(ConstDef.DONE);
                } else if ( type == ConstDef.IS_SHOW) {
                    ((ImageFileInfo) fileInfo).getGifFileInfo().setFileState(ConstDef.DONE);
                }
            }
            int leafPosition = adapter.getLeafPosition(bean.getId());
            if (leafPosition > -1){
                adapter.notifyItemRangeChanged(leafPosition, 1);
            }
            userCache.removeProgress(bean.getId());
        }
    }


    @Subscribe
    public void onRefreshSingleMessage(final IMProxyMessageEvent.RefreshMessageEvent event) {
        LogUtil.d("historyFileList", "Receiver:RefreshSingleMessageEvent");
        if(event == null){
            return;
        }
        TalkMessageBean bean = event.getTalkMessageBean();
        if(bean.getMessageState() == ConstDef.STATE_DESTROY || bean.getMessageState() == ConstDef.STATE_DESTROYING){
            List<TalkMessageBean> msgBeans = new ArrayList<>();
            msgBeans.add(bean);
            updateUIAfterDeleteFiles(msgBeans);
        }
    }

    @Subscribe
    public void onRefreshRecallMessage(final IMProxyMessageEvent.RecallMessageEvent event) {
        if (event == null || event.getTalkMessageBean() == null) {
            return;
        }
        TalkMessageBean bean = event.getTalkMessageBean();
        if (bean.getMessageState() == ConstDef.STATE_RECALL_SUCCESS) {
            List<TalkMessageBean> msgBeans = new ArrayList<>();
            msgBeans.add(bean);
            updateUIAfterDeleteFiles(msgBeans);
        }
    }

    @Subscribe
    public void onDeleteMessage(IMProxyMessageEvent.DeleteMessageEvent event) {
        if (event == null || event.getTalkMessageBean() == null) {
            LogUtil.e("", "event is null.");
            return;
        }
        TalkMessageBean  delBean = event.getTalkMessageBean();
        List<TalkMessageBean> deleteBeans = new ArrayList<>();
        deleteBeans.add(delBean);
        updateUIAfterDeleteFiles(deleteBeans);
    }


    @NonNull
    @Override
    protected Class<? extends IPhotoAndVideoFragmentVu> getVuClass() {
        return ViewPhotoAndVideo.class;
    }

    @NonNull
    @Override
    protected IPhotoAndVideoCommand getCommand() {
        return this;
    }

    public void updateMode(int operateAction) {
        adapter.updateMode(operateAction);
        getVu().showEmpty(dataSource.size() == 0);
    }
    
}
