package com.xdja.im.lib.historyfile.util;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataSourceFilter {

    //获取用户选择的
    public static List<TalkMessageBean> getCheckedDataSource(Map<HistoryFileCategory,List<TalkMessageBean>> dataSource){
        List<TalkMessageBean> beans = new ArrayList<>();
        for(Map.Entry<HistoryFileCategory,List<TalkMessageBean>> entry : dataSource.entrySet()){
            for(TalkMessageBean bean : entry.getValue()){
                if(bean.isChecked()){
                    beans.add(bean);
                }
            }
        }

        return beans;
    }

    //获取未过期的文件
    public static List<FileInfo> getWeeklyFileInfo(List<TalkMessageBean> beans){
        List<FileInfo> downloadFiles = new ArrayList<>();
        for(TalkMessageBean bean : beans){
            if(!DateUtils.isOverdue(bean.getShowTime())){
                downloadFiles.add(bean.getFileInfo());
            }
        }

        return downloadFiles;
    }

    public static List<FileInfo> getDownloadedFileInfo(List<TalkMessageBean> beans){
        List<FileInfo> downloadedFiles = new ArrayList<>();
        for(TalkMessageBean bean : beans){
            if(!DateUtils.isOverdue(bean.getShowTime()) &&
                    HistoryFileUtils.isFileExist(bean.getFileInfo().getFilePath())){
                downloadedFiles.add(bean.getFileInfo());
            }
        }

        return downloadedFiles;
    }

    public static List<FileInfo> getReCallFileInfo(List<TalkMessageBean> beans){
        List<FileInfo> reCallInfos = new ArrayList<>();
        for(TalkMessageBean bean : beans){
            if(bean.getMessageState() == ConstDef.STATE_RECALL_SUCCESS){
                reCallInfos.add(bean.getFileInfo());
            }
        }

        return reCallInfos;
    }

    public static TalkMessageBean updateSourceAfterRecall(Map<HistoryFileCategory,List<TalkMessageBean>> dataMaps,
                                               TalkMessageBean bean){
        String categoryId  = DateUtils.getCategoryIdWithTime(bean.getShowTime());
        HistoryFileCategory category = findCategoryById(dataMaps,categoryId);

        if(category != null){
            List<TalkMessageBean> messageBeans = dataMaps.get(category);
            if(messageBeans != null && messageBeans.size() > 0){
                int index = messageBeans.indexOf(bean);

                if(index >= 0){
                    TalkMessageBean oldMsg = messageBeans.get(index);
                    oldMsg.setMessageState(bean.getMessageState());
                    //oldMsg.setMessageType(bean.getMessageType());

                    if(oldMsg.getFileInfo() != null && oldMsg.getFileInfo().getFileState()
                            == ConstDef.LOADING){
                        oldMsg.getFileInfo().setFileState(ConstDef.PAUSE);
                    }
                    return oldMsg;
                }
            }
        }
        return null;
    }

    private static HistoryFileCategory findCategoryById(Map<HistoryFileCategory,List<TalkMessageBean>> dataMaps,
                                                        String categoryId){
        HistoryFileCategory category = null;
        Set<HistoryFileCategory> categorySets = dataMaps.keySet();

        if(categorySets.size() != 0){
            List<HistoryFileCategory> cateLists = new ArrayList<>(categorySets);

            HistoryFileCategory tempCate = new HistoryFileCategory();
            tempCate.setCategoryId(categoryId);

            int index = cateLists.indexOf(tempCate);
            if(index >= 0){
                category = cateLists.get(index);
            }
        }

        return category;
    }

    public static TalkMessageBean findMessageBeanWithId(Map<HistoryFileCategory,List<TalkMessageBean>> dataMaps,
                                                        long msgId){

        for(Map.Entry<HistoryFileCategory,List<TalkMessageBean>> entry : dataMaps.entrySet()){
            List<TalkMessageBean> beans = entry.getValue();
            for(TalkMessageBean bean : beans){
                if(bean.getId() ==  msgId){
                    return bean;
                }
            }
        }
        return null;
    }

    public static TalkMessageBean getTalkMessageBeanWithId(List<GridItemBean> dataSources, long msgId){
        for(GridItemBean gridItemBean : dataSources){
            if(gridItemBean.isLeaf()){
                TalkMessageBean bean = (TalkMessageBean) gridItemBean.getValue();
                if(bean.getId() == msgId){
                    return bean;
                }
            }
        }
        return  null;
    }
}
