package com.xdja.im.lib.historyfile.vu;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import androidx.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.presenter.BasePresenterActivity;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.video.utils.UnitUtil;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.image.BitmapUtils;
import com.xdja.im.uikit.view.CircleProgressBar;


public class ViewHistoryVideoItem extends ViewHistoryBaseItem {

    private CheckBox isSelect;
    private ImageView imgView;
    private TextView videoTime;
    private ImageView playerBtn;
    private CircleProgressBar circleProgressBar;
    private TextView videoShade;
    private int style = 0;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_file_image_fragment_video;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        style = UniversalUtil.getThemeStyle(getContext());
        if (view != null) {
            isSelect = (CheckBox) view.findViewById(R.id.chx_video_file_select);
            imgView = (ImageView) view.findViewById(R.id.history_file_video_img);
            videoTime = (TextView) view.findViewById(R.id.history_file_video_time);
            playerBtn = (ImageView) view.findViewById(R.id.history_file_video_btn_player);
            circleProgressBar = (CircleProgressBar) view.findViewById(R.id.video_down_cpb);
            videoShade = (TextView) view.findViewById(R.id.video_file_shade);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull GridItemBean dataSource) {
        super.bindDataSource(position, dataSource);
        final TalkMessageBean dataTalk = (TalkMessageBean) dataSource.getValue();

        circleProgressBar.setMax(100);
        if (dataTalk.getFileInfo().getFileState() == ConstDef.LOADING) {
            playerBtn.setVisibility(View.GONE);
            circleProgressBar.setVisibility(View.VISIBLE);
        } else {
            playerBtn.setVisibility(View.VISIBLE);
            circleProgressBar.setVisibility(View.GONE);
        }

        if (!HistoryFileUtils.isFileExist(dataTalk) &&
                DateUtils.isOverdue(dataTalk.getShowTime())) {
            videoShade.setVisibility(View.VISIBLE);
        } else {
            videoShade.setVisibility(View.GONE);
        }

        if (HistoryFileUtils.isSendReadReceipt(dataTalk)) {
            getCommand().sendReadReceipt(dataTalk);
        }

        isSelect.setVisibility(dataTalk.hasFileOperate() ? View.VISIBLE : View.GONE);
        isSelect.setClickable(false);
        isSelect.setButtonDrawable(dataTalk.isChecked() ? (style ==
                BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) :
                R.drawable.im_uikit_icon_selected_off);
        isSelect.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                dataTalk.setChecked(isChecked);
                isSelect.setButtonDrawable(isChecked ? (style ==
                        BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) :
                        R.drawable.im_uikit_icon_selected_off);
                if (isChecked) {
                    HistoryModeUtils.getInstance().putFileToSelectedCache(dataTalk.getId(), dataTalk);
                } else {
                    HistoryModeUtils.getInstance().removeToSelectedCache(dataTalk.getId());
                }
                getCommand().toRefreshSelectHint();
            }
        });
        isSelect.setChecked(dataTalk.isChecked());

        FileInfo videoFileInfo = dataTalk.getFileInfo();
        if (videoFileInfo != null) {
            if (HistoryFileUtils.isFileExist(videoFileInfo.getFilePath())) {
                loadImage(videoFileInfo.getFilePath());
            }
            videoTime.setText(UnitUtil.getVideoDuration(IMFileUtils.getVideoDuration(videoFileInfo.getFilePath()) / 1000));
        }
    }

    private void loadImage(String filePath) {
        if (TextUtils.isEmpty(filePath)) {
            imgView.setImageResource(R.drawable.im_uikit_pic_failed);
        } else {
            if (IMFileUtils.isVideoFileType(filePath)) {
                MediaMetadataRetriever mmr = new MediaMetadataRetriever();
                mmr.setDataSource(filePath);
                Bitmap bitmap = mmr.getFrameAtTime();
                imgView.setImageBitmap(BitmapUtils.getZoomedBitMap(bitmap, 1));
                mmr.release();
            } else {
                imgView.setImageBitmap(BitmapUtils.getZoomedDrawable(filePath, 1));
            }
        }
    }
}
