package com.xdja.im.lib.share.adapter;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.xdja.im.common.imageloader.GlideCircleTransform;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.share.presenter.ShareSessionListAdapterPresenter;
import com.xdja.im.uikit.R;

/**
 * Created by wenqi on 2018/3/2.
 *
 */

public class ShareViewHolder extends BaseShareViewHolder<ShareSessionListAdapterPresenter,TalkSessionBean> {

    private ImageView imgUserHeader;
    private TextView tvUserName;


    public ShareViewHolder(View itemView,ShareSessionListAdapterPresenter shareSessionListPresenter) {
        super(itemView,shareSessionListPresenter);
        imgUserHeader = (ImageView) itemView.findViewById(R.id.img_user_header);
        tvUserName = (TextView) itemView.findViewById(R.id.tv_user_name);
    }

    @Override
    public void bind(int position,final TalkSessionBean item) {
        if (item != null){
            addListener(item);

           /* IMUiKitProxyImpl.getInstance().getAccount(item.getTalkerAccount(), item.getTalkType(), new Subscriber<AccountBean>() {
                @Override
                public void onCompleted() {

                }

                @Override
                public void onError(Throwable e) {
                    e.printStackTrace();
                }

                @Override
                public void onNext(AccountBean accountBean) {
                    updateSessionBaseView(item,accountBean);
                }
            });*/

            updateSessionBaseView(item,IMUiKitProxyImpl.getInstance().getAccount(item.getTalkerAccount(), item.getTalkType()));
        }
    }

    private void addListener(final TalkSessionBean item) {
        itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().onItemClickListener(item);
            }
        });
    }

    private void updateSessionBaseView(TalkSessionBean item,AccountBean accountBean) {
        if (null == accountBean) return;

        if (!TextUtils.isEmpty(accountBean.getDisplayName())) {
            tvUserName.setText(accountBean.getDisplayName());
        } else {
            tvUserName.setText(accountBean.getAccount());
        }

        Drawable avatarDrawable = accountBean.getAvatarDrawable();
        if (avatarDrawable != null) {
            imgUserHeader.setImageDrawable(avatarDrawable);
            return;
        }

        int imgId = R.mipmap.im_uikit_user_header_40dp;
        if (item.getTalkType() == ConstDef.CHAT_TYPE_P2G) {
            imgId = R.mipmap.im_uikit_group_avatar_40;
        }
        String avatarUrl = accountBean.getAvatarUrl();
        Glide.with(getPresenter().getActivity())
                .load(avatarUrl)
                .placeholder(imgId)
                .error(imgId)
                .bitmapTransform(new GlideCircleTransform(getPresenter().getActivity()))
                .into(imgUserHeader);
    }


}
