package com.xdja.im.lib.video;

import android.app.Activity;
import android.content.Intent;
import androidx.fragment.app.Fragment;

import com.xdja.im.lib.video.ui.activity.VideoRecorderActivity;

/**
 * @Package: com.xdja.im.lib.video
 * @Author: xdjaxa
 * @Creation: 2017-04-26 9:07
 * @Version V1.0
 * @Description:
 */
public class VideoRecorderManager {

    private static class SingletonInstance {
        private static final VideoRecorderManager mInstance = new VideoRecorderManager();
    }

    private VideoRecorderManager() {
    }

    public static VideoRecorderManager getInstance() {
        return SingletonInstance.mInstance;
    }

    /**
     * 启动视频录制界面，从fragment启动
     *
     * @param fragment    Fragment实例
     * @param requestCode 请求码
     */
    public void startVideoRecorder(Fragment fragment, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(fragment.getContext(), VideoRecorderActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    /**
     * 启动视频录制界面，从Activity启动
     *
     * @param activity    Activity实例
     * @param requestCode 请求码
     */
    public void startVideoRecorder(Activity activity, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(activity, VideoRecorderActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }
}
