package com.xdja.im.uikit;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.text.TextUtils;

import com.xdja.im.base.di.component.ApplicationComponent;
import com.xdja.im.base.di.component.DaggerApplicationComponent;
import com.xdja.im.base.di.component.DaggerRepositoryComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.module.ApplicationModule;
import com.xdja.im.base.di.module.CacheModule;
import com.xdja.im.base.di.module.DataStoreModule;
import com.xdja.im.base.di.module.RepositoryModule;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.common.cache.entity.CardEntity;
import com.xdja.im.common.cache.entity.UserEntity;
import com.xdja.im.common.database.DatabaseManager;
import com.xdja.im.common.imageloader.GlideImageLoader;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.core.callback.AccountCallback;
import com.xdja.im.core.callback.ClearSessionDataCallback;
import com.xdja.im.core.callback.CommonCallback;
import com.xdja.im.core.callback.CustomComponentCallBack;
import com.xdja.im.core.callback.NotificationCallback;
import com.xdja.im.core.callback.NotificationChannelCallback;
import com.xdja.im.core.callback.OnAudioRecordCallback;
import com.xdja.im.core.callback.OnChatAt2GroupCallBack;
import com.xdja.im.core.callback.OnChatMeetCallBack;
import com.xdja.im.core.callback.OnChatSettingCallback;
import com.xdja.im.core.callback.OnChatUserInfoCallback;
import com.xdja.im.core.callback.OnEncryptListener;
import com.xdja.im.core.callback.OnImInitStateCallback;
import com.xdja.im.core.callback.OnOpenChatPageCallback;
import com.xdja.im.core.callback.OnShareOverCallback;
import com.xdja.im.core.callback.OnUserCanAccessToOptionCallBack;
import com.xdja.im.core.callback.SessionDeleteCallBack;
import com.xdja.im.core.callback.ShareSelectCallback;
import com.xdja.im.core.callback.UnReadMessageCallback;
import com.xdja.im.core.callback.UpDateSessionConfigCallback;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountAction;
import com.xdja.im.core.model.account.ActionDesc;
import com.xdja.im.core.model.account.GroupAction;
import com.xdja.im.core.model.custom.CustomMsgInfo;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkCustomBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkNotifyBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMModuleProxyImpl;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.proxy.ImUiKitContactProxyImpl;
import com.xdja.im.core.push.PushControllerImp;
import com.xdja.im.core.service.KitService;
import com.xdja.im.core.utils.CommonUtils;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.lib.album.ImagePickerConfig;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.camera.CameraManager;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.historyfile.ui.HistoryFileActivityPresenter;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.uikit.notification.NotificationUtil;
import com.xdja.im.uikit.ui.ListItemUtils;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.utils.ClassUtils;
import com.xdja.im.uikit.utils.PromptPictureUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.tbs.TbsBrowseUtils;
import com.xdja.imsdk.ImSdkService;
import com.xdja.imsdk.model.IMMessage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.uikit
 * @Author: xdjaxa
 * @Creation: 2017-04-13 9:51
 * @Version V1.0
 * @Description:
 */
@SuppressLint("StaticFieldLeak")
public class ImUiKit implements IClient {

    private ApplicationComponent applicationComponent;

    private RepositoryComponent repositoryComponent;

    private ImageLoader mImageLoader;

    /**
     * 配置信息
     */
    private UiKitOptions sdkOptions;
    /**
     * 初始化参数信息
     */
    private UiKitParams sdkParams;
    /**
     * 当前用户
     */
    private String curAccount;

    private static ImUiKit imUiKit;

    /**
     * 是否初始化
     */
    private boolean isInit;

    /**
     * 主界面是否存在
     */
    public boolean isMainTabExist = false;


    private Context sContext;

    private String appId;

    private boolean isShareActivityRegister = false;

    private ImUiKit() {
    }

    private static class SingletonInstance {
        private static final ImUiKit mInstance = new ImUiKit();
    }

    public static ImUiKit getInstance() {
        return SingletonInstance.mInstance;
    }
//    @Override
//    public synchronized void init(Context context, @Nullable UiKitOptions options) {
//        //log
//        //LogUtil.init(false, "ImUiKit");
//        //CrashHandler.getInstance().init(context);
//
//        LogUtil.d("ImUiKit Init.");
//        sContext = context.getApplicationContext();
//        sdkOptions = options;
//
//        //初始化组件
//        initComponent();
//        //图片选择界面初始化
//        initImagePicker();
//        isInit = true;
//    }

    @Override
    public synchronized void init(Context context, @NonNull UiKitParams params, @Nullable UiKitOptions options) {

        //log
        //LogUtil.init(false, "ImUiKit");
        //CrashHandler.getInstance().init(context);
        LogUtil.d("ImUiKit Init.");

        if (params == null || params.getAccountBean() == null ||
                TextUtils.isEmpty(params.getAccountBean().getAccount())) {
            LogUtil.e("Init user account is null error!");
            return;
        }
        sContext = context.getApplicationContext();
        sdkOptions = options;
        sdkParams = params;
        curAccount = params.getAccountBean().getAccount();
        isInit = true;
        LogUtil.d("params:" + params.toString());
        //初始化组件
        initComponent();
        //保存数据
        initData();
        //PushSdk初始化
        initPushClient();
        //IM初始化
        initIMProxy();
        //数据库初始化
        initDatabases();
        //图片选择界面初始化
        initImagePicker();

        try {
            TbsBrowseUtils.initializeTBS(context.getApplicationContext());
        } catch (Exception e) {
            e.printStackTrace();
        }

        isMainTabExist = true;
        isShareActivityRegister = ClassUtils.getInstance().isRegisterActivity(context, "ShareSessionListActivity");
    }

    @Override
    public void release(int flag) {

        LogUtil.d("ImUiKit release.");

        //IMSdk释放
        //缓存清理（本地需要清理的，内存缓存清理）
        DatabaseManager.getInstance().close();
        IMModuleProxyImpl.getInstance().releaseProxy();
        IMUiKitProxyImpl.getInstance().releaseProxy();
        PromptPictureUtils.getInstance().unRegisterContentObserver(getContext());
        if (flag == 1) {
            PushControllerImp.getInstance().releasePush();
        }
        isInit = false;
        isMainTabExist = false;
    }

    @Override
    public UiKitOptions getOptions() {
        return sdkOptions;
    }

    @Override
    public void sendNotifyTextMessage(String sessionId, int sessionType, TalkNotifyBean bean) {
        IMModuleProxyImpl.getInstance().sendNotifyMessage(sessionId, sessionType, bean);
    }

    @Override
    public void sendShareContact(int type, List<ShareBean> list) {
        IMModuleProxyImpl.getInstance().sendShareInfo(type, list);
    }

    /**
     * 争对警视的自定义消息
     *
     * @param sessionId   如果是群组，则是群ID；如果是单聊，则是会话ID
     * @param sessionType 0：群组 1：单聊
     * @param bean        消息实体
     */
    @Override
    public void sendCustomTextMessage(String sessionId, int sessionType, TalkCustomBean bean) {
        IMModuleProxyImpl.getInstance().sendCustomTextMessage(sessionId, sessionType, bean);
    }

    /**
     * 发送自定义消息，通用，需添加相关item才能使用
     *
     * @param talkId
     * @param talkType
     * @param jsonContent 消息实体
     */
    @Override
    public void sendCustomMessage(String talkId, int talkType, String jsonContent) {
        IMModuleProxyImpl.getInstance().sendCustomMessage(talkId, talkType, jsonContent);
    }

    @Override
    public void clearSessionData(String sessionId, int sessionType) {
        IMModuleProxyImpl.getInstance().clearSessionData(sessionId, sessionType);
    }

    @Override
    public void clearSessionData(String sessionId, int sessionType, ClearSessionDataCallback callback) {
        IMModuleProxyImpl.getInstance().clearSessionData(sessionId, sessionType, callback);
    }

    @Override
    public void clearAllSessionData() {
        IMModuleProxyImpl.getInstance().clearAllSessionData();
    }

    @Override
    public void clearAllCacheData() {
        IMModuleProxyImpl.getInstance().clearCacheData();
    }

    /**
     * 删除三方自定义消息（消息助手）
     *
     * @param bean 消息实体
     */
    @Override
    public void deleteThirdMessage(TalkMessageBean bean) {
        IMModuleProxyImpl.getInstance().deleteThirdContent(bean);
    }

    @Override
    public void setReceiveMode(String sessionId, int sessionType, boolean isOpen) {
        IMModuleProxyImpl.getInstance().setReceiveMode(sessionId, sessionType, isOpen);
    }

    @Override
    public void setNoDisturbMode(String sessionId, int sessionType, boolean isDisturb) {
        IMModuleProxyImpl.getInstance().setNoDisturbMode(sessionId, sessionType, isDisturb);
    }

    @Override
    public void setSessionTop(String sessionId, int sessionType, boolean isTop) {
        IMModuleProxyImpl.getInstance().setSessionTop(sessionId, sessionType, isTop);
    }

    @Override
    public SessionParam getSessionParam(String sessionId, int sessionType) {
        return IMModuleProxyImpl.getInstance().getSessionParam(sessionId, sessionType);
    }

    @Override
    public void notifyAccountChanged(String account, AccountAction action) {
        IMUiKitProxyImpl.getInstance().notifyAccountChanged(account, action);
    }

    @Override
    public void notifyGroupChanged(String groupId, GroupAction action, ActionDesc actionDesc) {
        ImUiKitContactProxyImpl.getInstance().notifyGroupChanged(groupId, action, actionDesc);
    }

    @Override
    public void setNotificationChannelCallback(NotificationChannelCallback callback) {
        IMUiKitProxyImpl.getInstance().setNotificationChannelCallback(callback);
    }

    @Override
    public void registerAccountCallback(AccountCallback callback) {
        IMUiKitProxyImpl.getInstance().setAccountCallback(callback);
    }

    @Override
    public void registerAndAddCustomChatListItem(int type, Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>> customItem) {
        ListItemUtils.getInstance().addChatListItemAndPaser(type, customItem);
    }

    @Override
    public void registerNotificationCallback(NotificationCallback callback) {
        IMUiKitProxyImpl.getInstance().setNotificationCallback(callback);
    }

    @Override
    public void registerUnReadMessageCallback(UnReadMessageCallback callback) {
        IMUiKitProxyImpl.getInstance().setUnReadMessageCallback(callback);
    }

    @Override
    public void registerCustomComponentCallBack(CustomComponentCallBack callBack) {
        IMUiKitProxyImpl.getInstance().setCustomComponentCallBack(callBack);
    }

    @Override
    public void registerOpenChatSettingCallback(OnChatSettingCallback callback) {
        IMUiKitProxyImpl.getInstance().setOpenChatSettingCallback(callback);
    }

    @Override
    public void registerOpenChatUserInfoCallback(OnChatUserInfoCallback callback) {
        IMUiKitProxyImpl.getInstance().setOpenChatUserInfoCallback(callback);
    }

    @Override
    public void registerOnOpenChatPageCallback(OnOpenChatPageCallback callback) {
        IMUiKitProxyImpl.getInstance().setOnOpenChatPageCallback(callback);
    }

    @Override
    public void registerCommonCallback(CommonCallback callback) {
        IMUiKitProxyImpl.getInstance().setCommonCallback(callback);
    }

    @Override
    public void registerAddChtMeeting(OnChatMeetCallBack callBack) {
        IMUiKitProxyImpl.getInstance().setOnChatMeetCallBack(callBack);
    }

    @Override
    public void registerEncryptListener(OnEncryptListener onEncryptListener) {
        getComponent().onEncryptCallback().registerEncryptListener(onEncryptListener);
    }


    /**
     * 分享操作回掉
     *
     * @param callback
     */
    @Override
    public void registerShareSelectCallback(ShareSelectCallback callback) {
        IMUiKitProxyImpl.getInstance().setShareSelectCallback(callback);
    }

    @Override
    public void registerOnShareOverCallback(OnShareOverCallback callback) {
        IMUiKitProxyImpl.getInstance().registerOnShareOverCallback(callback);
    }

    @Override
    public void registerAtMembsItemClickCallBack(String groupId, String account, String nickName) {
        IMUiKitProxyImpl.getInstance().notifyGroupMembsItemClick(groupId, account, nickName);
    }

    @Override
    public void registerUserAccessToOption(OnUserCanAccessToOptionCallBack callBack) {
        IMUiKitProxyImpl.getInstance().setUserAccessToOption(callBack);
    }

    @Override
    public void registerOnImInitStateCallback(OnImInitStateCallback callback) {
        IMUiKitProxyImpl.getInstance().setOnImInitStateCallback(callback);
    }

    @Override
    public void registerOnAudioRecordCallback(OnAudioRecordCallback callback) {
        IMUiKitProxyImpl.getInstance().setOnAudioRecordCallback(callback);
    }

    /**
     * @param activity activity
     * @param content  第三方转发内容
     */
    @Override
    public void forwardThirdContent(Activity activity, String content) {
        IMModuleProxyImpl.getInstance().forwardThirdContent(activity, content);
    }

    @Override
    public void removeAccountCache(String account) {
        try {
            String sessionFlagSingle = ToolUtils.getSessionTag(account, ConstDef.CHAT_TYPE_P2P);
            String sessionFlagGroup = ToolUtils.getSessionTag(account, ConstDef.CHAT_TYPE_P2G);
            String sessionFlagCustom = ToolUtils.getSessionTag(account, ConstDef.CHAT_TYPE_SYSTEM_INFO);
            DataCache.getInstance().remove(sessionFlagSingle);
            DataCache.getInstance().remove(sessionFlagGroup);
            DataCache.getInstance().remove(sessionFlagCustom);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 会话数据集合
     */
    private List<TalkSessionBean> mSessionList = new ArrayList<>();

    @Override
    public void registerInitUnReadMsgCallBack() {
        getComponent().proxyRepository().getSessionListBeans("", 0, ConstDef.CHAT_TYPE_DEFAULT, new Subscriber<List<TalkSessionBean>>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onNext(final List<TalkSessionBean> sessionBeanList) {
                getComponent().userOperateRepository().getAllSessionParams(new Subscriber<List<SessionParam>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {

                    }

                    @Override
                    public void onNext(List<SessionParam> sessionParams) {
                        if (sessionParams == null || sessionParams.isEmpty()) {
                            //剔除重复的会话
                            mSessionList.clear();
                            Iterator<TalkSessionBean> iterator = sessionBeanList.iterator();
                            for (; iterator.hasNext(); ) {
                                TalkSessionBean bean = iterator.next();

                                int index = sessionBeanList.indexOf(bean);
                                if (index > -1 && bean != sessionBeanList.get(index)) {
                                    iterator.remove();
                                }
                            }
                            mSessionList.addAll(sessionBeanList);

                            int unReadCount = 0;
                            for (TalkSessionBean bean : sessionBeanList) {
                                unReadCount += bean.getNotReadCount();//未读消息处理
                                SessionParam param = bean.getParam();
                                if (null != param && param.isDisturb()) {
                                    unReadCount -= bean.getNotReadCount();
                                }
                                IMUiKitProxyImpl.getInstance().updateUnReadMessageCount(unReadCount);
                            }
                            return;
                        }

                        for (int i = 0; i < sessionParams.size(); i++) {
                            SessionParam param = sessionParams.get(i);
                            TalkSessionBean tempBean = new TalkSessionBean();
                            tempBean.setTalkFlag(param.getSessionFlag());
                            int index = sessionBeanList.indexOf(tempBean);
                            if (index >= 0) {
                                //更新草稿信息
                                TalkSessionBean talkSessionBean = sessionBeanList.get(index);
                                talkSessionBean.setParam(param);

                                if (TextUtils.isEmpty(talkSessionBean.getLastMsgAccount()) &&
                                        talkSessionBean.getLastTime() > 0) {
                                    if (param.getDraftTime() > talkSessionBean.getLastTime()) {
                                        talkSessionBean.setLastTime(param.getDraftTime());
                                    }
                                }
                                if (!TextUtils.isEmpty(param.getDraftContent()) && param.getDraftTime() > 0) {
                                    talkSessionBean.setLastTime(param.getDraftTime());
                                }
                            } else {
                                //会话不存在，则生成新会话
                                if (param.getDraftTime() > 0) {
                                    TalkSessionBean talkSessionBean = new TalkSessionBean();
                                    talkSessionBean.setTalkFlag(param.getSessionFlag());
                                    talkSessionBean.setLastTime(param.getDraftTime());
                                    talkSessionBean.setParam(param);
                                    sessionBeanList.add(talkSessionBean);
                                }
                            }
                        }

                        Collections.sort(sessionBeanList);
                        //剔除重复的会话
                        mSessionList.clear();
                        Iterator<TalkSessionBean> iterator = sessionBeanList.iterator();
                        for (; iterator.hasNext(); ) {
                            TalkSessionBean bean = iterator.next();

                            int index = sessionBeanList.indexOf(bean);
                            if (index > -1 && bean != sessionBeanList.get(index)) {
                                iterator.remove();
                            }
                        }
                        mSessionList.addAll(sessionBeanList);

                        int unReadCount = 0;
                        for (TalkSessionBean bean : sessionBeanList) {
                            unReadCount += bean.getNotReadCount();//未读消息处理
                            SessionParam param = bean.getParam();
                            if (null != param && param.isDisturb()) {
                                unReadCount -= bean.getNotReadCount();
                            }
                            IMUiKitProxyImpl.getInstance().updateUnReadMessageCount(unReadCount);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void registerAtOpenGroupCallBack(OnChatAt2GroupCallBack onChatAt2GroupCallBack) {
        IMUiKitProxyImpl.getInstance().setAt2GroupMembersCallback(onChatAt2GroupCallBack);
    }

    @Override
    public void registerSessionDeleteCallBack(SessionDeleteCallBack sessionDeleteCallBack) {
        IMUiKitProxyImpl.getInstance().setSessionDeleteCallBack(sessionDeleteCallBack);
    }


    @Override
    public void openHistoryChatFile(Activity activity, String sessionId, int sessionType, boolean ifRecall) {
        Intent intent = null;
        if (sessionType == IntentParam.SESSION_TYPE_P2P) {
            intent = new Intent(activity, HistoryFileActivityPresenter.class);
        } else if (sessionType == IntentParam.SESSION_TYPE_P2G) {
            intent = new Intent(activity, HistoryFileActivityPresenter.class);
        }
        if (intent != null) {
            intent.putExtra(ConstDef.TAG_TALKFLAG, ToolUtil.getSessionTag(sessionId, sessionType));
            intent.putExtra(ConstDef.TAG_TALKERID, sessionId);
            if (ifRecall) {
                activity.startActivityForResult(intent, ConstDef.HISTORY_FILE_RECALL);
            } else {
                activity.startActivity(intent);
            }
        }
    }

    @Override
    public void notifyMeet(MeetInfo meetInfo) {
        IMModuleProxyImpl.getInstance().notifyMeet(meetInfo);
    }

    /**
     * 组件初始化
     */
    private void initComponent() {
        applicationComponent = DaggerApplicationComponent.builder()
                .applicationModule(new ApplicationModule())
                .cacheModule(new CacheModule())
                .build();

        repositoryComponent = DaggerRepositoryComponent.builder()
                .applicationComponent(applicationComponent)
                .dataStoreModule(new DataStoreModule())
                .repositoryModule(new RepositoryModule())
                .build();
    }

    /**
     * 初始化数据信息
     */
    private void initData() {
        //account
        String account = sdkParams.getAccountBean().getAccount();
        String pushAppId = sdkParams.getAppId();
        String pushUserId = sdkParams.getPushUserId();
        String clientId = pushAppId + "/" + pushUserId;
        String fastDfsAddr = sdkParams.getFastDfsAddr();
        String fastUserId = sdkParams.getFastUserId();
        String fastUserSecret = sdkParams.getFastUserSecret();
        String ifEncrypt = sdkParams.getIfEncrypt();
        String ticket = "01edbce2bfca663294c99a3f8f6e497c";
        int keystoreId = sdkParams.getKeystoreId();
        String keystorePsd = sdkParams.getKeystorePsd();

        int mxKeystoreId = sdkParams.getMxKeystoreId();
        String mxKeystorePsd = sdkParams.getMxKeystorePsd();

        int fileKeystoreId = sdkParams.getFileKeystoreId();
        String fileKeystorePsd = sdkParams.getFileKeystorePsd();

        UserEntity userEntity = new UserEntity();
        userEntity.setAccount(account);
        userEntity.setTicket(ticket);
        userEntity.setClientId(clientId);
        userEntity.setFastDfsAddr(fastDfsAddr);
        userEntity.setFastUserId(fastUserId);
        userEntity.setFastUserSecret(fastUserSecret);
        if (!TextUtils.isEmpty(ifEncrypt))
            userEntity.setIfEncrypt(ifEncrypt);
        if (keystoreId == 0) {
            keystoreId = R.raw.trust;
            keystorePsd = "xdja1234";
        }

        if (mxKeystoreId == 0) {
            mxKeystoreId = R.raw.trust;
            mxKeystorePsd = "xdja1234";
        }
        userEntity.setKeystoreId(keystoreId);
        userEntity.setKeystorePsd(keystorePsd);
        userEntity.setMxKeystoreId(mxKeystoreId);
        userEntity.setMxKeystorePsd(mxKeystorePsd);
        userEntity.setFileKeystoreId(fileKeystoreId);
        userEntity.setFileKeystorePsd(fileKeystorePsd);
        repositoryComponent.accountCache().put(userEntity);

        CardEntity cardEntity = new CardEntity();
        int index = clientId.lastIndexOf("/") + 1;
        cardEntity.setCardId(clientId.substring(index));
        repositoryComponent.cardCache().put(cardEntity);

        NotificationUtil.getInstance().setLoginAccount(account);
        LogUtil.d("sdkParams:" + sdkParams.toString());
    }

    /**
     * PushSDK初始化
     */
    private void initPushClient() {
        PushControllerImp.getInstance().startPush(sdkParams.getAppId(), sdkParams.getPushUserId(), null);
    }

    /**
     * IMServer初始化
     */
    private void initIMProxy() {
        IMModuleProxyImpl.getInstance().initIMProxy();
    }

    /**
     * IM数据库初始化
     */
    private void initDatabases() {
        String account = sdkParams.getAccountBean().getAccount();
        if (TextUtils.isEmpty(account)) {
            LogUtil.e("ERROR: Init account is null error.");
            return;
        }
        DatabaseManager.getInstance().initDatabase(sContext, account);
    }

    /**
     * 图片消息加载器
     */
    private void initImagePicker() {

        ImagePickerConfig config = new ImagePickerConfig();
        config.setColumnNum(3);              //每行显示图片个数
        config.setMaxSize(ImUiKit.getInstance().getComponent().configCache().getDevice().getFileSize() * 1024 * 1024); //最大可发送图片大小
        config.setMaxSelectNum(9);  //最多可选择图片个数(只有设置mode为MODE_MULTIPLE时，起作用)
        config.setMode(ImagePickerConfig.MODE_MULTIPLE);       //可多选
        config.setType(ImagePickerConfig.TYPE_IMAGE);          //只显示图片
        //config.setType(ImagePickerConfig.TYPE_WITH_CAMERA);  //显示图片和拍照
        //config.setType(ImagePickerConfig.TYPE_ALL);          //显示图片、拍照、视频

        ImagePickerManager.getInstance().setConfig(config);

        //图片加载器
        //mImageLoader = new DefaultImageLoader();
        mImageLoader = new GlideImageLoader();
        ImagePickerManager.getInstance().setImageLoader(mImageLoader);

        CameraManager.getInstance().setImageLoader(mImageLoader);
    }

    public ImageLoader getImageLoader() {
        return mImageLoader;
    }

    public RepositoryComponent getComponent() {
        return repositoryComponent;
    }

    public Context getContext() {
        return sContext;
    }

    public String getChannelId() {
        return sdkParams.getChannelId();
    }

    public String getChannelName(){
        return sdkParams.getChannelName();
    }

    public UiKitOptions getSdkOptions() {
        return sdkOptions;
    }

    public String getCurAccount() {
        return curAccount;
    }

    public void setCurAccount(String curAccount) {
        this.curAccount = curAccount;
    }

    public void saveCustomMsgInfo(CustomMsgInfo msgInfo) {
        repositoryComponent.proxyRepository().saveCustomIMMessage(msgInfo, new Subscriber<IMMessage>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onNext(IMMessage imMessage) {
                LogUtil.d("CustomMsg", "保存自定义一消息成功");
            }
        });
    }

    public boolean isInit() {
        return isInit;
    }

    public boolean isMainTabExist() {
        return isMainTabExist;
    }

    public void setMainTabExist(boolean mainTabExist) {
        isMainTabExist = mainTabExist;
    }

    public void clearSessionCache() {
        IMUiKitProxyImpl.getInstance().clearSessionCache();
    }

//    private boolean isOA;
//
//    public boolean isOA() {
//        return isOA;
//    }
//
//    public void setOA(boolean OA) {
//        isOA = OA;
//    }

    public String getAppId() {
        if (sdkParams != null) {
            return sdkParams.getAppId();
        }
        return appId;
    }

    public void setUpDateSessionConfig(UpDateSessionConfigCallback upDateSessionConfig) {
        IMUiKitProxyImpl.getInstance().setUpDateSessionConfig(upDateSessionConfig);
    }


    public boolean isShareActivityRegister() {
        return isShareActivityRegister;
    }

    /**
     * KitService或ImSdkService被销毁，需重新初始化ImUiKit
     *
     * @return
     */
    public boolean isImUiKitServiceDestroy(){
        if(!CommonUtils.isServiceRunning(sContext, KitService.class.getName())){
            LogUtil.d("KitService is destroy");
            return true;
        }
        if(!CommonUtils.isServiceRunning(sContext, ImSdkService.class.getName())){
            LogUtil.d("ImSdkService is destroy");
            return true;
        }
        return false;
    }
}
