package com.xdja.im.uikit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.IntDef;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.ui.activity.ChatListActivity;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

/**
 * @Package: com.xdja.im.uikit
 * @Author: xdjaxa
 * @Creation: 2017-05-23 10:04
 * @Version V1.0
 * @Description:
 */
public class IntentParam {

    /**
     * 启动聊天界面action
     */
    public static final String ACTION_CHAT = "action.xjda.im.uikit.chatlist";
    /**
     * 启动聊天列表界面action
     */
    public static final String ACTION_FRAGMENT_LIST_CHAT = "action.xjda.im.uikit.chatfragmentlist";
    /**
     * UiKit 默认的聊天界面
     */
    public static final String ACTION_CHAT_DEF = "action.xjda.im.uikit.chatlist.def";
    /**
     * UiKit 默认的聊天助手界面
     */
    public static final String ACTION_ASSISTANT_CHAT_DEF = "action.xjda.im.uikit.assistant.def";
    /**
     * 用户设置界面action
     */
    public static final String ACTION_USER_DETAIL = "action.xdja.im.uikit.user.detail";
    public static final String ACTION_GROUP_DETAIL = "action.xdja.im.uikit.group.detail";
    /**
     * 进入聊天相关参数
     */
    public static final String PARAM_CHAT = "Param_chatList";
    /**
     * 进入设置相关参数
     */
    public static final String PARAM_SETTING = "Param_setting";
    /**
     * 会话ID，在同一账号中唯一
     */
    public static final String PARAM_SESSION_ID = "talkerId";
    /**
     * 会话类型，值为单聊或者群聊
     * 值见{@link Session}
     */
    public static final String PARAM_SESSION_TYPE = "talkType";
    /**
     * 账号信息
     */
    public static final String PARAM_ACCOUNT = "account";

    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {SESSION_TYPE_P2P, SESSION_TYPE_P2G, SESSION_TYPE_ASS})
    public @interface Session {
    }

    /**
     * 单人聊天
     */
    public static final int SESSION_TYPE_P2P = 1;
    /**
     * 群组聊天
     */
    public static final int SESSION_TYPE_P2G = 2;
    /**
     * 助手类型
     */
    public static final int SESSION_TYPE_ASS = 201;

    /**
     * 文本和图片转发界面返回码
     */
    public static final int REQUEST_CODE_FORWARD = 3;

    /**
     * 启动聊天界面
     *
     * @param context     上下文
     * @param sessionId   会话ID
     * @param sessionType 会话类型
     */
    public static void startChatActivity(Context context, String sessionId, int sessionType) {
        Intent intent = new Intent();
        if (CommonTool.getPlatformType() == Constant.PLATFORM_OA) {
            intent.setAction(ACTION_CHAT);
        } else {
            intent.setAction(context.getPackageName() + "." + ACTION_CHAT_DEF);
        }
        Bundle arguments = new Bundle();
        arguments.putString(IntentParam.PARAM_SESSION_ID, sessionId);
        arguments.putInt(IntentParam.PARAM_SESSION_TYPE, sessionType);
        intent.putExtras(arguments);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setPackage(context.getPackageName());
        context.startActivity(intent);
    }

    /**
     * 启动消息助手界面
     *
     * @param context     上下文
     * @param sessionId   会话ID
     * @param sessionType 会话类型
     */
    public static void startSystemAssistantActivity(Context context, String sessionId, int sessionType) {
        Intent intent = new Intent();
//        if (CommonTool.getPlatformType() == Constant.PLATFORM_OA) {
//            intent.setAction(ACTION_CHAT);
//        } else {
        intent.setAction(context.getPackageName() + "." + ACTION_ASSISTANT_CHAT_DEF);
//        }
//        intent.setClass(context, AssistantListActivity.class);
        Bundle arguments = new Bundle();
        arguments.putString(IntentParam.PARAM_SESSION_ID, sessionId);
        arguments.putInt(IntentParam.PARAM_SESSION_TYPE, sessionType);
        intent.putExtras(arguments);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setPackage(context.getPackageName());
        context.startActivity(intent);
    }

    public static void startChatActivity(Context context, String sessionId, int sessionType, int[] cancelPopMenuIdArray) {
        Intent intent = new Intent();
        if (CommonTool.getPlatformType() == Constant.PLATFORM_OA) {
            intent.setAction(ACTION_CHAT);
        } else {
            intent.setAction(context.getPackageName() + "." + ACTION_CHAT_DEF);
        }
        Bundle arguments = new Bundle();
        arguments.putString(IntentParam.PARAM_SESSION_ID, sessionId);
        arguments.putInt(IntentParam.PARAM_SESSION_TYPE, sessionType);
        if (cancelPopMenuIdArray.length > 0)
            arguments.putIntArray(ChatListActivity.EXTRA_KEY_CANCEL_BOTTOM_POP_MENU_ID_ARRAY, cancelPopMenuIdArray);
        intent.putExtras(arguments);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setPackage(context.getPackageName());
        context.startActivity(intent);
    }

    /**
     * 启动聊天列表界面
     *
     * @param context  上下文
     * @param talkerId 会话ID
     * @param talkType 会话类型
     */
    public static void startChatListActivity(Activity context, String talkerId, int talkType, ArrayList<FileInfo> transmitFiles) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putSerializable(ConstDef.TAG_SELECTFILE, transmitFiles);
        intent.putExtras(bundle);
        intent.setAction(context.getPackageName() + "." + ACTION_FRAGMENT_LIST_CHAT);
        intent.putExtra(ConstDef.TAG_TALKERID, talkerId);
        intent.putExtra(ConstDef.TAG_TALKTYPE, talkType);//消息类型
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setPackage(context.getPackageName());
        context.startActivityForResult(intent, REQUEST_CODE_FORWARD);
    }

    /**
     * 启动聊天界面
     *
     * @param context 上下文
     */
    public static void startChatActivity(Context context, Bundle arguments) {
        Intent intent = new Intent();
        intent.setAction(ACTION_CHAT);
        intent.putExtra(PARAM_CHAT, arguments);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setPackage(context.getPackageName());
        context.startActivity(intent);
    }

    /**
     * 启动设置界面
     *
     * @param context
     * @param sessionId
     * @param sessionType
     */
    public static void startSettingActivity(Context context, String sessionId, int sessionType) {
        Intent intent = new Intent();
        if (sessionType == ConstDef.CHAT_TYPE_P2P) {
            intent.setAction(ACTION_USER_DETAIL);
        } else {
            intent.setAction(ACTION_GROUP_DETAIL);
        }
        Bundle arguments = new Bundle();
        arguments.putString(IntentParam.PARAM_SESSION_ID, sessionId);
        arguments.putInt(IntentParam.PARAM_SESSION_TYPE, sessionType);
        intent.putExtra(PARAM_SETTING, arguments);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setPackage(context.getPackageName());
        context.startActivity(intent);
    }
}


