package com.xdja.im.uikit.base;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;

import com.xdja.im.uikit.R;

/**
 * Created by wangzhen-PC on 2018/1/10.
 */

public abstract class ImBaseSettingActivity extends AppCompatActivity implements View.OnClickListener{

    public ImageButton ibBack, ibOk;
    public TextView tvTitle;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int layoutView = getLayoutView();
        setContentView(layoutView);
        getAnimTransition(R.anim.im_uikit_open_enter, R.anim.im_uikit_open_exit);

        initView();
        initData();
    }

    public abstract void initView();

    public void initData() {}

    public abstract int getLayoutView();

    /**
     * 单独初始化title中控件
     */
    protected void initTitle() {
        ibBack = (ImageButton)this.findViewById(R.id.ib_back);
        tvTitle = (TextView) this.findViewById(R.id.tv_title);
        ibOk = (ImageButton) this.findViewById(R.id.ib_ok);

        ibBack.setOnClickListener(this);
        ibOk.setOnClickListener(this);
    }

    public void setTitle(String customTitle) {
        if(TextUtils.isEmpty(customTitle)) {
            tvTitle.setText("");
        }else {
            tvTitle.setText(customTitle);
        }
    }

    public void onClickToBack(View view) {
        finish();
    }

    public void onClickToOk(View view) {}

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        getAnimTransition(R.anim.im_uikit_close_enter, R.anim.im_uikit_close_exit);
    }

    /**
     * 进入退出activity界面动画
     * @param im_uikit_open_enter
     * @param im_uikit_open_exit
     */
    private void getAnimTransition(int im_uikit_open_enter, int im_uikit_open_exit) {
        overridePendingTransition(im_uikit_open_enter, im_uikit_open_exit);
    }
}
