package com.xdja.im.uikit.base;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewTreeObserver;

import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.presenter.BaseActivityPresenter;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.NetworkUtil;

import java.util.Locale;

import androidx.annotation.Nullable;

/**
 * @Package: com.xdja.im.uikit.presenter.activity
 * @Author: xdjaxa
 * @Creation: 2017-04-11 10:37
 * @Version V1.0
 * @Description:
 */
public abstract class ShareImBaseActivity<P extends Presenter, V extends BaseView> extends BaseActivityPresenter<P, V> {

    protected UserComponent mComponent;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        setTheme(R.style.im_uikit_ImAppTheme);
        super.onCreate(savedInstanceState);
        Intent intent = getIntent();
        if (intent != null && !TextUtils.isEmpty(intent.getAction()) &&  intent.getAction().equals("android.intent.action.MAIN")){
            try {
                Intent intent2 = getPackageManager().getLaunchIntentForPackage(getContext().getPackageName());
                startActivity(intent2);
                finish();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null && ImUiKit.getInstance().isMainTabExist()) {
            mComponent = DaggerUserComponent.builder()
                    .repositoryComponent(repositoryComponent)
                    .build();
        } else {
            try {
                Intent intent = getPackageManager().getLaunchIntentForPackage(getContext().getPackageName());
                startActivity(intent);
                finish();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mComponent == null) {
            LogUtil.e("Fatal :User component is null .");
            finish();
        }

        getWindow().getDecorView().getViewTreeObserver().addOnWindowFocusChangeListener(
                new ViewTreeObserver.OnWindowFocusChangeListener() {
                    @Override
                    public void onWindowFocusChanged(boolean hasFocus) {
                        onActivityFocusChanged(hasFocus);
                    }
                });
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        if (newConfig.fontScale != 1) {
            getResources();
        }
        super.onConfigurationChanged(newConfig);
    }

    @Override
    public Resources getResources() {
        boolean isChangeFontScale = CommonTool.isChangeFontScale();
        if (isChangeFontScale) {
            return super.getResources();
        }
        Resources resources = super.getResources();
        Configuration configuration = resources.getConfiguration();//modify by xnn @20170303 review by tangsha
        configuration.setLocale(Locale.CHINA);
        configuration.fontScale = 1.0f;
        try {
            resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return resources;
    }

    /**
     * 启动申请权限框
     */
    protected void showMissingPermissionDialog() {
        new CustomDialog(getContext(), new CustomDialog.OnCloseListener() {
            @Override
            public void onClick(Dialog dialog, boolean confirm) {
                if (confirm) {
                    startAppSettings();
                } else {
                    finish();
                }
            }
        })
                .setDialogTitle(R.string.im_uikit_hint)
                .setDialogContent(R.string.im_uikit_permission_hint)
                .setPositiveButton(R.string.im_uikit_setting)
                .setNegativeButton(R.string.im_uikit_btn_cancel)
                .show();
    }

    /**
     * 启动应用的设置
     */
    private void startAppSettings() {
        Intent intent = new Intent(
                Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        intent.setData(Uri.parse("package:" + getPackageName()));
        startActivity(intent);
    }

    /**
     * 监测网络是否需要进行文件发送操作
     *
     * @param result 回调接口
     */
    protected void checkNetType(final OnNetCheckCallback result) {

        boolean isMobileConnected = NetworkUtil.isConnectByMobile(getContext());
        if (isMobileConnected) {
            new CustomDialog(getContext(), new CustomDialog.OnCloseListener() {
                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    result.onResult(!confirm);
                }
            })
                    .setDialogTitle(result.getTitle())
                    .setDialogContent(result.getContent())
                    .setPositiveButton(result.getPositiveButton())
                    .setNegativeButton(result.getNegativeButton())
                    .show();
        } else {
            result.onResult(false);
        }
    }

    public abstract class OnNetCheckCallback {

        /**
         * 是否已取消
         *
         * @param isCanceled
         */
        public abstract void onResult(boolean isCanceled);

        protected String getContent() {
            return "";
        }

        protected String getTitle() {
            return getString(R.string.im_uikit_hint);
        }

        protected String getPositiveButton() {
            return getString(R.string.im_uikit_btn_continue);
        }

        protected String getNegativeButton() {
            return getString(R.string.im_uikit_btn_cancel);
        }
    }

    protected Context getContext() {
        return this;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    /**
     * 窗口焦点发生变化
     *
     * @param hasFocus
     */
    protected void onActivityFocusChanged(boolean hasFocus) {
    }

    /**
     * Toast提示
     *
     * @param content
     */
    protected void showToast(String content) {
        CommonTool.showToast(content);
    }

    /**
     * Toast提示
     *
     * @param resId
     */
    protected void showToast(int resId) {
        CommonTool.showToast(resId);
    }
}
