package com.xdja.im.uikit.notification;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

public class NotificationReceiver extends BroadcastReceiver {

    private String targetActivity = "";
    private Bundle preBundle;

    private boolean validArgs(Intent preIntent) {
        if (preIntent == null) {
            return false;
        }
        preBundle = preIntent.getExtras();
        if (preBundle == null) {
            return false;
        }
        targetActivity = preBundle.getString(NotifyConstant.NOTIFYTARGET);
        //目标页面为空时，退出转换页面
        if (TextUtils.isEmpty(targetActivity)) {
            return false;
        }
        return true;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        if ((context.getPackageName() + NotifyConstant.NOTIFYACTION).equals(intent.getAction())) {
            if (!validArgs(intent)) {
                return;
            }
            Intent newIntent = null;
            try {
                newIntent = new Intent();
                newIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP
                        | Intent.FLAG_ACTIVITY_SINGLE_TOP
                        | Intent.FLAG_ACTIVITY_NEW_TASK);
                newIntent.setAction(targetActivity);
                newIntent.putExtras(preBundle);
                context.startActivity(newIntent);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }
}
