package com.xdja.im.uikit.notification;

import android.content.Context;
import android.media.AudioManager;

public class NotifySettings {

    private AudioManager audioManager;

    public NotifySettings(Context context) {
        audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
    }

    public NotifyConfigBean obtainNotifySetting(boolean notify) {
        NotifyConfigBean configBean = new NotifyConfigBean();
        //获取系统是否开启消息提醒
        boolean sysNotify = true;
        //判断当前是否处在勿扰模式下
        boolean currIsDisturb = false;

        //应用程序开启震动
        boolean appShark = true;
        //应用程序开启响铃
        boolean appRing = true;

        if (sysNotify && notify) {
            configBean.setIsRemind(true);
        } else {
            configBean.setIsRemind(false);
        }

        if (configBean.isRemind()) {
            if (currIsDisturb) {
                configBean.setHasVoice(false);
                configBean.setHasShake(false);
            } else {
                int mode = audioManager.getRingerMode();
                boolean sysShake;
                boolean sysVoice;
                if (mode == AudioManager.RINGER_MODE_SILENT) {
                    sysShake = false;
                    sysVoice = false;
                } else if (mode == AudioManager.RINGER_MODE_VIBRATE) {
                    //当前系统情景模式为震动
                    sysShake = true;
                    sysVoice = false;
                } else {
                    //当前系统情景模式为铃声
                    sysShake = true;
                    sysVoice = true;
                }

                //当前系统为震动，应用程序同时也开启，则启用震动,否则关闭
                if (sysShake && appShark) {
                    configBean.setHasShake(true);
                } else {
                    configBean.setHasShake(false);
                }

                //当前系统为响铃，应用程序同时也开启，则启用响铃,否则关闭
                if (sysVoice && appRing) {
                    configBean.setHasVoice(true);
                } else {
                    configBean.setHasVoice(false);
                }
            }
        }
        return configBean;
    }
}
