package com.xdja.im.uikit.ui.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.im.common.database.dao.MeetInfoEntityDao;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.action.ChatActionView;
import com.xdja.im.lib.action.ChatInputView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.listener.IChatActionCallback;
import com.xdja.im.lib.action.listener.IChatActionItemClickListener;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.video.utils.DisplayUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.vu.ChatListVu;
import com.xdja.im.uikit.utils.FunctionUtils;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.utils.PromptPictureUtils;
import com.xdja.im.uikit.view.KeyboardLayout;
import com.xdja.im.uikit.view.PromptPictureView;

import java.util.List;

import androidx.annotation.DrawableRes;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

import static com.xdja.im.lib.camera.utils.CameraHelper.PATH_DCIM;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-19 14:58
 * @Version V1.0
 * @Description: 聊天列表界面
 */
public class ViewChatList extends ImFragmentSuperView<ChatListPresenter> implements ChatListVu {

    private final static String TAG = "ViewChatList";

    private KeyboardLayout mRootLayout;

    private RelativeLayout mContentLayout;

    private RelativeLayout scrollLayout;
    private TextView button;
    /**
     * 滑动前后的纵坐标
     */
    private float upY = 0;
    private float downY = 0;
    /**
     * 消息列表控件
     */
    private ListView mChatListView;
    /**
     * 操作输入控件
     */
    private ChatInputView mChatInputView;

    /**
     * 消息操作面板
     */
    private ChatActionView mChatActionView;

    /**
     * 下拉刷新组件
     */
    private SwipeRefreshLayout swipeRefreshLayout;

    /**
     * 键盘
     */
    private InputMethodManager inputMethodManager;

    /**
     * 网络状态组件
     *
     * @return
     */
    //private LinearLayout networkStateLineaLayout;
    /**
     * 网络状态显示组件
     *
     * @return
     */
    //private TextView networkStateTv;


    private RelativeLayout im_uikit_meeting_tips_layout;

    private TextView im_uikit_meeting_tips_txt;

    private PromptPictureView promptPictureView;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_chat_list;
    }

    @Override
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    protected void injectView() {
        super.injectView();

        mRootLayout = (KeyboardLayout) findViewById(R.id.root_layout);
        mContentLayout = (RelativeLayout) findViewById(R.id.content_layout);

        mChatListView = (ListView) findViewById(R.id.lv_message_list);
        mChatInputView = (ChatInputView) findViewById(R.id.layout_chat_operate);
        mChatActionView = (ChatActionView) findViewById(R.id.layout_chat_action);
        swipeRefreshLayout = (SwipeRefreshLayout) findViewById(R.id.swipe_container);
        //networkStateLineaLayout = (LinearLayout) findViewById(R.id.network_state_view);
        //networkStateTv = (TextView) findViewById(R.id.networkstate_tv);

        //根据静态注册的广播接收器中保存的当前网络状态是否可用的值，来确定View是否可见
        //changeNetworkViewState(NetworkHelper.getHelper().getNetState());

        im_uikit_meeting_tips_layout = (RelativeLayout) findViewById(R.id.im_uikit_meeting_tips_layout);
        im_uikit_meeting_tips_txt = (TextView) findViewById(R.id.im_uikit_meeting_tips_txt);
        promptPictureView = (PromptPictureView) findViewById(R.id.prompt_picture_view);
        im_uikit_meeting_tips_layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().addMeeting();
            }
        });

        if (getPresenter().getTalkType() == ConstDef.CHAT_TYPE_SYSTEM_INFO) {
            mChatInputView.setVisibility(View.GONE);
            mChatActionView.setVisibility(View.GONE);
        }

        createBtnView();
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        inputMethodManager = ((InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE));

        swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                getPresenter().downRefreshList();
            }
        });

        if (getPresenter().getTalkType() != ConstDef.CHAT_TYPE_SYSTEM_INFO) {
            registerInputCallback();
            mRootLayout.setActivity(getActivity());
            mChatActionView.setAcceptInput(mChatInputView.getInputEdt());
        }
        initChatListListView();

        setNavigateCallback(new onNavigateCallback() {
            @Override
            public void onBackClick() {
                hideSoftInputView();
            }

            @Override
            public void onAddClick() {
                getPresenter().startSetting();
            }
        });

        promptPictureView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!TextUtils.isEmpty(promptPictureView.getPath())) {
                    getPresenter().clickPromptPicture(promptPictureView.getPath());
                }
            }
        });
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        supportActionBar(visibility == View.VISIBLE);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        setToolBarAddVisible(visibility == View.VISIBLE);
    }

    @Override
    public void setToolBarAddImageId(@DrawableRes int id) {
        setToolBarAddImage(id);
    }

    @Override
    public void setTitle(String title) {
        if (isSupportActionBar()) {
            setToolBarTitle(title);
        }
    }

    @Override
    public void setAdapter(ChatListAdapter adapter) {
        mChatListView.setAdapter(adapter);
        adapter.notifyDataSetChanged();
    }

    @Override
    public void setOptions(List<OptionBean> options) {
        if (mChatActionView != null) {
            mChatActionView.setOptionsData(options);
        }
    }

    @Override
    public ListView getListView() {
        return mChatListView;
    }

    /**
     * 设置listview item间距
     *
     * @param height
     */
    @Override
    public void setDividerHeight(int height) {
        mChatListView.setDividerHeight(height);
    }

    @Override
    public String getInputContent() {
        return mChatInputView.getInputText();
    }

    @Override
    public void setInputContent(String content) {
        if (!TextUtils.isEmpty(content)) {
            mChatInputView.setIsDraft(true);
            mChatActionView.formatSpanContent(content);
        }
        mChatInputView.setInputText(content);
    }


    @Override
    public boolean isRefreshing() {
        return swipeRefreshLayout.isRefreshing();
    }

    @Override
    public void stopRefresh() {
        swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setListSelection(int selection) {
        if (mChatListView != null) {
            mChatListView.setSelection(selection);
        }
    }

    @Override
    public void scrollTo(int x, int y) {
        if (mChatActionView != null) {
            mChatListView.scrollTo(x, y);
        }
    }

    /**
     * 消息输入回调
     * 尽量的少操作ChatInputView自身的控件，重点进行逻辑处理
     */
    private void registerInputCallback() {
        mChatInputView.registerActionViewCallBack(new IChatActionCallback() {
            @Override
            public void onVirtualViewCallBack() {

            }

            @Override
            public void onMoreCheckChanged() {

                if (mChatActionView.isActionViewVisible()) {
                    hideActionView(false);
                    restoreActionState();
                    // promptPictureView.setVisibility(View.GONE);
                } else {
                    String path = PromptPictureUtils.getInstance().getLatestPhotoPath();
                    if (!TextUtils.isEmpty(path) && !path.contains(Environment.getExternalStorageDirectory() + PATH_DCIM)) {
                        promptPictureView.setVisibility(View.VISIBLE);
                        promptPictureView.loadImage(path);
                    } else {
                        promptPictureView.setVisibility(View.GONE);
                    }
                    mChatActionView.setEmojiVisible(false);
                    showActionView(0);
                    mChatInputView.setMoreState(true);
                    mChatActionView.setActionViewVisible(true);
                }
            }

            @Override
            public void onShanCheckChanged() {

                //闪信
                //getPresenter().setLimitFlagFromView(isChecked);
                //mChatActionView.updateGrid(isChecked);

                //表情
                if (mChatActionView.isEmojiVisible()) {
                    hideActionView(true);
                    restoreActionState();

                    setEditTextFocus(true);
                } else {
                    showActionView(1);
                    mChatInputView.setShanState(true);
                    mChatActionView.setEmojiVisible(true);
                }
            }

            @Override
            public void onInputCheckChanged(boolean isChecked) {

                //isChecked false 语音  true 文字
                if (isChecked) {
                    if (mChatActionView.isShown()) {
                        hideActionView(true);
                    }
                } else {
                    if (mRootLayout.isSoftInputShown()) {
                        hideSoftInputView();
                    }
                    if (mChatActionView.isShown()) {
                        hideActionView(false);
                    }
                    restoreActionState();
                }
            }

            @Override
            public void onSendTextCallBack() {
                String content = mChatInputView.getInputText();
                if (TextUtils.isEmpty(content.trim())) {
                    CommonTool.showToast(R.string.im_uikit_content_cannot_null);
                    return;
                }

                if (getPresenter().sendTextMessage(content)) {
                    mChatInputView.setInputText("");
                }
            }

            @Override
            public void onInputEareTouchCallBack() {

                if (mChatActionView.isShown()) {
                    restoreActionState();
                }
                if (mChatListView.getTranscriptMode() != AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
                    mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
                }
            }

            @Override
            public void onRecorderFinish(int seconds, String filePath) {
                getPresenter().sendVoiceMessage(filePath, seconds);
            }
        });

        mChatActionView.setChatActionItemClickListener(new IChatActionItemClickListener() {
            @Override
            public void onItemClick(int position, OptionBean optionBean) {

                if (IMUiKitProxyImpl.getInstance().isAccessToOption(optionBean)) {
                    // TODO: 2017/7/12
                    if (optionBean.getId() == 5 || optionBean.getId() == 6) {
                        getPresenter().startVoice(position, optionBean);
                    } else if (optionBean.getId() == 8) {
                        getPresenter().startLocation(position, optionBean);
                    } else if (optionBean.getId() == 7) {
                        getPresenter().startCallback(position, optionBean);
                    } else if (optionBean.getId() > 8) {
                        getPresenter().startCustomCallback(optionBean);
                    } else {
                        getPresenter().startToOptionView(position, optionBean);
                    }
                }
            }
            /*@Override
            public void onItemClick(int position, @ActionMode.ACTION int action) {
                switch (action) {
                    case ActionMode.ACTION_EMOTION:
                        mChatActionView.setEmojiVisible(!mChatActionView.isEmojiVisible());
                        break;
                    case ActionMode.ACTION_IMAGE:
                        getPresenter().startToAlbum();
                        break;
                    case ActionMode.ACTION_CAMERA:
                        getPresenter().startToCamera();
                        break;
                    case ActionMode.ACTION_VIDEO:
                        getPresenter().startToVideo();
                        break;
                    case ActionMode.ACTION_FILE:
                        getPresenter().startToFileExplorer();
                        break;
                }
            }*/
        });
    }

    /**
     * 添加显示列表的监听事件
     */
    private void initChatListListView() {
        mChatListView.setOnTouchListener(new View.OnTouchListener() {
            @SuppressLint("ClickableViewAccessibility")
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == MotionEvent.ACTION_DOWN) {
                    if (mChatActionView.isShown()) {
                        restoreActionState();
                        return true;
                    }
                    mChatListView.setFocusable(true);
                    displayInputKeyBoard(false);
                    downY = event.getY();
                }

                if (event.getAction() == MotionEvent.ACTION_MOVE) {
                    upY = event.getY();
                }

                if (scrollLayout != null) {
                    if (event.getAction() == MotionEvent.ACTION_UP) {
                        if (upY - downY > 0 &&
                                (Math.abs(upY - downY) > 20)) {
                            removeButtonView();
                        }
                    }

                }

                return false;
            }
        });
        mChatListView.setOnScrollListener(new AbsListView.OnScrollListener() {

            @Override
            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == AbsListView.OnScrollListener.SCROLL_STATE_IDLE) {
                    int firstVisibleItem = mChatListView.getFirstVisiblePosition();
                    int endVisibleItem = mChatListView.getLastVisiblePosition();
                    getPresenter().listScroll(firstVisibleItem, endVisibleItem);
                }
            }

            @Override
            public void onScroll(AbsListView view, int firstVisibleItem,
                                 int visibleItemCount, int totalItemCount) {
                mChatListView.setFocusable(true);
            }
        });
    }

    /**
     * 显示或者隐藏EditText对应的软键盘
     *
     * @param isShow 显示或者隐藏
     */
    public void displayInputKeyBoard(boolean isShow) {
        setEditTextFocus(isShow);
        if (!isShow) {
            inputMethodManager.hideSoftInputFromWindow(mChatInputView.getInputEdt().getWindowToken(), 0);
            if (mChatListView.getTranscriptMode() == AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
                mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
            }
        } else {
            inputMethodManager.toggleSoftInput(0, InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }

    /**
     * 设置EditText对应的焦点
     *
     * @param isShow 获取焦点或者是去焦点
     */
    private void setEditTextFocus(boolean isShow) {
        if (isShow) {
            mChatInputView.getInputEdt().setFocusable(true);
            mChatInputView.getInputEdt().setFocusableInTouchMode(true);
            mChatInputView.getInputEdt().requestFocus();
        } else {
            mChatInputView.getInputEdt().setFocusable(false);
        }
    }

    /**
     * 重置action面板状态
     */
    @Override
    public void restoreActionState() {
        mChatActionView.setVisibility(View.GONE);
        mChatInputView.setShanState(false);
        mChatInputView.setMoreState(false);
        if (mChatListView.getTranscriptMode() == AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
            mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
        }
    }

    /**
     * AT长按头像，输入框输入，面板与软键盘交互
     *
     * @param
     */
    private void showInputBoardAndHideAction() {
        mChatActionView.setVisibility(View.GONE);
        mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
        setEditTextFocus(true);
    }

    @Override
    public void setTalkType(int talkType) {
        if (mToolbarAdd != null) {
            if (talkType == ConstDef.CHAT_TYPE_P2P) {
                mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add);
                mChatInputView.setChatType(talkType);
            } else if (talkType == ConstDef.CHAT_TYPE_P2G) {
                mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add_p2g);
                mChatInputView.setChatType(talkType);
            }
        }
    }

    @Override
    public void setGroupId(String groupId) {
        if (!TextUtils.isEmpty(groupId)) {
            mChatInputView.setGroupId(groupId);
        }
    }

    @Override
    public void setAccount(String account) {
        if (!TextUtils.isEmpty(account)) {
            mChatInputView.setAccount(account);
        }
    }

    @Override
    public void showAtActionView() {
//        if (!mChatActionView.isActionViewVisible())
//            showActionView();
        if (!inputMethodManager.isActive())
            displayInputKeyBoard(true);
    }

    @Override
    public void setAtText(String s, int type) {
        if (mChatInputView.getInputEdt().length() + s.length() > 2048) {
            new XToast(getActivity()).display(R.string.im_uikit_input_length_warnning);
            return;
        }
        if (type == ConstDef.CLICK_IMAGE) {
            showInputBoardAndHideAction();
            if (mChatInputView.getInputEdt().getText().toString().contains(s)) return;
        }
        int index = mChatInputView.getInputEdt().getSelectionStart();
        Editable editable = mChatInputView.getInputEdt().getEditableText();
        if (index < 0 || index >= editable.length()) {
            editable.append(s);
        } else {
            editable.insert(index, s);
        }
    }

    /**
     * EditText 获取焦点并显示软键盘
     */
    public void showSoftInputFromWindow(Activity activity, EditText editText) {
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        playInputKeyBoard(editText);
    }

    public void playInputKeyBoard(EditText inputEare) {
        inputMethodManager.showSoftInput(inputEare, 0);
    }

    @Override
    public void setChatMeet(String talkFlag) {
        Observable.just(talkFlag)
                .subscribeOn(Schedulers.newThread())
                .map(new Func1<String, MeetInfo>() {
                    @Override
                    public MeetInfo call(String s) {
                        MeetInfo meetInfo = MeetInfoEntityDao.getInstance().get(s);
                        return meetInfo;
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MeetInfo>() {
                    @Override
                    public void onCompleted() {
                    }

                    @Override
                    public void onError(Throwable e) {
                        e.printStackTrace();
                        im_uikit_meeting_tips_layout.setVisibility(View.GONE);
                    }

                    @Override
                    public void onNext(MeetInfo meetInfo) {
                        if (meetInfo != null) {
                            if (meetInfo.getIsShow() == 1 && meetInfo.getTaklFlag().equals(getPresenter().getTalkFlag())) {
                                im_uikit_meeting_tips_layout.setVisibility(View.VISIBLE);
                            } else {
                                im_uikit_meeting_tips_layout.setVisibility(View.GONE);
                            }
                            if (!TextUtils.isEmpty(meetInfo.getTips()))
                                im_uikit_meeting_tips_txt.setText(meetInfo.getTips());
                        } else {
                            im_uikit_meeting_tips_layout.setVisibility(View.GONE);
                        }
                    }
                });
    }

    @Override
    public void setChatMeetTips(String tips) {
        if (!TextUtils.isEmpty(tips) && im_uikit_meeting_tips_txt != null) {
            im_uikit_meeting_tips_txt.setText(tips);
        }
    }

    /**
     * 显示控制面板
     */
    public void showActionView(int action) {

        if (mRootLayout.isSoftInputShown()) {
            lockContentViewHeight(action);
            hideSoftInputView();
            restoreActionState();
            unlockContentViewHeightDelayed();
        }

        if (mChatListView.getTranscriptMode() != AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
            mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
        }
        mChatActionView.setVisibility(View.VISIBLE);
        mChatInputView.switchToInputEdt(true);
    }

    /**
     * 隐藏控制面板，并根据参数进行输入法的显示
     *
     * @param isShowSoftInputView
     */
    public void hideActionView(boolean isShowSoftInputView) {
        if (mChatActionView.isShown()) {
            mChatActionView.setVisibility(View.GONE);
            promptPictureView.setVisibility(View.GONE);
            if (mChatListView.getTranscriptMode() == AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
                mChatListView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
            }
            if (isShowSoftInputView) {
                showSoftInputView();
            }
        }
    }

    /**
     * 固定控制面板之外的内容布局的高度
     */
    public void lockContentViewHeight(int action) {
        LinearLayout.LayoutParams params = getLayoutParamsForContent();
        float softHeight = mRootLayout.getSupportSoftInputHeight();
        params.height = (int) (mContentLayout.getHeight() + (softHeight - mChatActionView.getActionHeight(action)));
        params.weight = 0;
    }

    /**
     * 释放掉控制面板之外的内容布局的高度
     */
    public void unlockContentViewHeightDelayed() {
        mChatInputView.getInputEdt().postDelayed(new Runnable() {
            @Override
            public void run() {
                LinearLayout.LayoutParams params = getLayoutParamsForContent();
                params.weight = 1;
                mContentLayout.invalidate();
            }
        }, 200);
    }

    /**
     * 获取控制面板之外的内容布局的布局参数
     *
     * @return
     */
    private LinearLayout.LayoutParams getLayoutParamsForContent() {
        return (LinearLayout.LayoutParams) mContentLayout.getLayoutParams();
    }

    /**
     * 显示输入法
     */
    private void showSoftInputView() {
        final EditText et = mChatInputView.getInputEdt();
        et.requestFocus();
        et.post(new Runnable() {
            @Override
            public void run() {
                inputMethodManager.showSoftInput(et, 0);
            }
        });
    }

    /**
     * 隐藏输入法
     */
    private void hideSoftInputView() {
        inputMethodManager.hideSoftInputFromWindow(mChatInputView.getInputEdt().getWindowToken(), 0);
    }

    @Override
    public void changeViewSate(int state) {
        //changeNetworkViewState(state);
        if (!NetworkHelper.getHelper().isFirstNotice()
                && FunctionUtils.isAppOnForeground(getActivity())) {
            if (state == NetworkHelper.NET_DISABLED) {
                Toast.makeText(getActivity(), "Network unavailable", Toast.LENGTH_LONG).show();
            } else if (state == NetworkHelper.NO_SERVER) {
                Toast.makeText(getActivity(), "Unable to access the server", Toast.LENGTH_LONG).show();
            }
        }
    }

    @Override
    public void setMeetState(boolean isShow, int talkType) {
        if (isShow && talkType == ConstDef.CHAT_TYPE_P2G) {
            im_uikit_meeting_tips_layout.setVisibility(View.VISIBLE);
        } else {
            im_uikit_meeting_tips_layout.setVisibility(View.GONE);
        }
    }

    /**
     * 网络状态监测
     */
//    private void changeNetworkViewState(int flag) {
//        String tips;
//        switch (flag) {
//            case NetworkHelper.NET_DISABLED:
//                tips = getActivity().getResources().getString(R.string.im_uikit_network_disabled);
//                networkStateTv.setText(tips);
//                networkStateLineaLayout.setVisibility(View.VISIBLE);
//                break;
//            case NetworkHelper.NO_SERVER:
//                tips = getActivity().getResources().getString(R.string.im_uikit_network_no_server);
//                networkStateTv.setText(tips);
//                networkStateLineaLayout.setVisibility(View.VISIBLE);
//                break;
//            case NetworkHelper.NET_OK:
//                networkStateLineaLayout.setVisibility(View.GONE);
//                break;
//            default:
//                break;
//        }
//    }
    @Override
    public synchronized void addButtonView(final int number) {
        if (scrollLayout == null) {
            createBtnView();
        }
        String title;
        if (number < 99) {
            title = number + getActivity().getString(R.string.im_uikit_new_message_title);
        } else {
            title = Html.fromHtml("<b>...</b>") + getActivity().getString(R.string.im_uikit_new_message_title);
        }
        button.setText(title);
        scrollLayout.setVisibility(View.VISIBLE);
        scrollLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                getPresenter().setNoReadNumber();
                removeButtonView();
            }
        });
    }

    @Override
    public synchronized void removeButtonView() {
        if (scrollLayout != null) {
            mContentLayout.removeView(scrollLayout);
            scrollLayout = null;
        }
    }

    @Override
    public void setSelection(int length, int position) {
        if (mChatListView != null) {
            int lastVisiblePosition = mChatListView.getLastVisiblePosition();
            if (lastVisiblePosition == position) {
                mChatListView.setSelection(position);
            }
        }
    }


    private void createBtnView() {
        Bitmap bitmap;
        if (UniversalUtil.getLanguageType(getActivity()) == UniversalUtil.LANGUAGE_EN) {
            bitmap = BitmapFactory.decodeResource(getActivity().getResources(), R.drawable.im_uikit_new_message_bg_p);
        } else {
            bitmap = BitmapFactory.decodeResource(getActivity().getResources(), R.drawable.im_uikit_messages_bg_p);
        }
        int w = RelativeLayout.LayoutParams.WRAP_CONTENT;
        int h = RelativeLayout.LayoutParams.WRAP_CONTENT;
        if (bitmap != null) {
            w = bitmap.getWidth();
            h = bitmap.getHeight();
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(w, h);
        layoutParams.setMargins(0, 200, 0, 0);
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
        scrollLayout = new RelativeLayout(getActivity());
        scrollLayout.setClickable(true);
        mContentLayout.addView(scrollLayout, layoutParams);
        scrollLayout.setBackgroundResource(R.drawable.im_uikit_messages_bg_p);
        button = new TextView(getActivity());
        button.setPadding(5, 0, 10, 10);
        RelativeLayout.LayoutParams buttonParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        buttonParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        buttonParams.addRule(RelativeLayout.CENTER_VERTICAL);
        button.setTextColor(getResources().getColor(R.color.im_uikit_message_tips_color));
        button.setTextSize(DisplayUtils.px2dp(getContext(), getResources().getDimension(R.dimen.im_uikit_message_tips_size)));
//        getResources().getDimension(R.dimen.im_uikit_message_tips_size)
        scrollLayout.addView(button, buttonParams);
        if (bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        scrollLayout.setVisibility(View.GONE);
    }

}
