package com.xdja.im.uikit.ui.view;

import androidx.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.CircleImageView;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:43
 * @Version V1.0
 * @Description:
 */
public class ViewRecvWebItem extends BaseReceiveItem {

    private final static String TAG = "ViewSendWebItem";

    private TextView recvWebTitle;
    private TextView recvWebDes;
    private ImageView recvWebThumb;
    private CircleImageView ivHeader;

    public ViewRecvWebItem() {
        super();
    }

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_rec_web;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        recvWebTitle = (TextView) view.findViewById(R.id.web_title);
        recvWebDes = (TextView) view.findViewById(R.id.web_des);
        recvWebThumb = (ImageView) view.findViewById(R.id.web_thumb);
        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().clickWebMessage(dataSource);
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        initView();
    }

    private void initView() {
        WebPageInfo webPageInfo = dataSource.getWebPageInfo();
        if(webPageInfo != null) {
            String webUri = webPageInfo.getWebUri();
            String description = webPageInfo.getDescription();
            String source = webPageInfo.getSource();
            String title = webPageInfo.getTitle();
            Glide.with(getActivity())
                    .load(webPageInfo.getFilePath())
                    .placeholder(R.drawable.im_uikit_default_web_word)
                    .error(R.drawable.im_uikit_default_web_word)
                    .into(recvWebThumb);
            recvWebTitle.setText(title);
            recvWebDes.setText(description);
        }
    }
}
