package com.xdja.im.uikit.ui.view;

import androidx.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.CircleProgressBar;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:44
 * @Version V1.0
 * @Description:
 */
public class ViewSendVideoItem extends BaseSendItem {

    /**
     * 图片加载显示控件
     */
    private ChatImageView mChatImage;
    /**
     * 播放标识
     */
    private ImageView mPlayFlagImg;
    /**
     * 文件发送进度
     */
    private CircleProgressBar mLoadingPBar;
    /**
     * 视频时长显示
     */
    private TextView mVideoTimeTv;

    /**
     * 文件下载进度条
     * @return
     */
    private ProgressBar loadProgressBar;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_video;
    }


    @Override
    protected void injectView() {
        super.injectView();
        mChatImage = (ChatImageView) findViewById(R.id.img_send_image);
        mPlayFlagImg = (ImageView) findViewById(R.id.img_play_flag);
        mLoadingPBar = (CircleProgressBar) findViewById(R.id.pbar_video_loading);
        mVideoTimeTv = (TextView) findViewById(R.id.tv_video_duration);
        loadProgressBar = (ProgressBar) findViewById(R.id.pbar_loading) ;

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewVideo(dataSource);
            }
        });
        mPlayFlagImg.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewVideo(dataSource);
            }
        });
        mPlayFlagImg.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return showPopDialog();
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull final TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        VideoFileInfo videoFileInfo = (VideoFileInfo) dataSource.getFileInfo();
        if (videoFileInfo == null) {
            LogUtil.e("Video file info is null error.");
            return;
        }
        mPlayFlagImg.setVisibility(View.VISIBLE);
        mVideoTimeTv.setVisibility(View.VISIBLE);

        //更新进度
        updateProgress(videoFileInfo.getTranslatePercent());
        //加载缩略图
        loadImage(videoFileInfo);

        mVideoTimeTv.setText(String.format(getStringRes(R.string.im_uikit_video_duration),
                videoFileInfo.getAmountOfTime() / 60,   //分
                videoFileInfo.getAmountOfTime() % 60)); //秒
    }

    /**
     * 加载视频第一帧图片
     *
     * @param fileInfo
     */
    private void loadImage(VideoFileInfo fileInfo) {

        @ConstDef.FileState
        int state = fileInfo.getFileState();
        switch (state) {
            case ConstDef.UPLOAD_DONE:
                loadFirstImage(fileInfo);
                break;
            case ConstDef.UPLOAD_FAIL:
                loadFirstImage(fileInfo);
                break;
            case ConstDef.UPLOAD_INACTIVE:
                loadFirstImage(fileInfo);
                break;
            case ConstDef.UPLOAD_LOADING:
                loadFirstImage(fileInfo);
                break;
            case ConstDef.UPLOAD_PAUSE:
                loadFirstImage(fileInfo);
                break;
            case ConstDef.DONE:
                loadFirstImage(fileInfo);
                break;
            case ConstDef.FAIL:
                updateLoadProgress(false);
                mVideoTimeTv.setVisibility(View.GONE);
                mPlayFlagImg.setVisibility(View.GONE);
                mChatImage.setError(R.mipmap.im_uikit_ic_video_failed);
                break;
            case ConstDef.INACTIVE:
                getPresenter().downLoadFile(dataSource, fileInfo);
                updateLoadProgress(true);
                break;
            case ConstDef.LOADING:
                getPresenter().downLoadFile(dataSource, fileInfo);
                updateLoadProgress(true);
                break;
            case ConstDef.PAUSE:
                getPresenter().downLoadFile(dataSource, fileInfo);
                updateLoadProgress(true);
                break;
        }
    }

    private void loadFirstImage(VideoFileInfo fileInfo) {
        if (FileUtils.isFileExists(fileInfo.getFilePath())) {
            updateLoadProgress(false);
            mChatImage.loadImage(fileInfo.getFilePath(),ConstDef.SEND_IMAGE);
        } else {
            updateLoadProgress(false);
            mVideoTimeTv.setVisibility(View.GONE);
            mPlayFlagImg.setVisibility(View.GONE);
            mChatImage.setError(R.mipmap.im_uikit_ic_video_failed);
        }
    }

    /**
     * 更新文件加载进度
     *
     * @param percent 视频文件发送进度
     */
    private void updateProgress(int percent) {
        if (dataSource.getMessageState() == ConstDef.STATE_SENDING) {
            mPlayFlagImg.setVisibility(View.GONE);
            mLoadingPBar.setVisibility(View.VISIBLE);
            mLoadingPBar.setProgress(percent);
        } else {
            mPlayFlagImg.setVisibility(View.VISIBLE);
            mLoadingPBar.setVisibility(View.GONE);
        }
    }

    /**
     * 下载进度条更新
     */
    private void updateLoadProgress(boolean update) {
        if (update) {
            mPlayFlagImg.setVisibility(View.GONE);
            mChatImage.setVisibility(View.GONE);
            loadProgressBar.setVisibility(View.VISIBLE);
        } else {
            mPlayFlagImg.setVisibility(View.VISIBLE);
            mChatImage.setVisibility(View.VISIBLE);
            loadProgressBar.setVisibility(View.GONE);
        }
    }
}
